/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.utils.MetaStoreIterator;
import org.apache.hadoop.utils.MetadataStore;
import org.iq80.leveldb.DBIterator;

public class LevelDBStoreIterator
implements MetaStoreIterator<MetadataStore.KeyValue> {
    private DBIterator levelDBIterator;

    public LevelDBStoreIterator(DBIterator iterator) {
        this.levelDBIterator = iterator;
        this.levelDBIterator.seekToFirst();
    }

    @Override
    public boolean hasNext() {
        return this.levelDBIterator.hasNext();
    }

    @Override
    public MetadataStore.KeyValue next() {
        if (this.levelDBIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)this.levelDBIterator.next();
            return MetadataStore.KeyValue.create((byte[])entry.getKey(), (byte[])entry.getValue());
        }
        throw new NoSuchElementException("LevelDB Store has no more elements");
    }

    @Override
    public void seekToFirst() {
        this.levelDBIterator.seekToFirst();
    }

    @Override
    public void seekToLast() {
        this.levelDBIterator.seekToLast();
    }
}

