/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.EntryConsumer;
import org.apache.hadoop.utils.MetaStoreIterator;
import org.apache.hadoop.utils.MetadataKeyFilters;

@InterfaceStability.Evolving
public interface MetadataStore
extends Closeable {
    public void put(byte[] var1, byte[] var2) throws IOException;

    public boolean isEmpty() throws IOException;

    public byte[] get(byte[] var1) throws IOException;

    public void delete(byte[] var1) throws IOException;

    public List<Map.Entry<byte[], byte[]>> getRangeKVs(byte[] var1, int var2, MetadataKeyFilters.MetadataKeyFilter ... var3) throws IOException, IllegalArgumentException;

    public List<Map.Entry<byte[], byte[]>> getSequentialRangeKVs(byte[] var1, int var2, MetadataKeyFilters.MetadataKeyFilter ... var3) throws IOException, IllegalArgumentException;

    public void writeBatch(BatchOperation var1) throws IOException;

    public void compactDB() throws IOException;

    public void destroy() throws IOException;

    public ImmutablePair<byte[], byte[]> peekAround(int var1, byte[] var2) throws IOException, IllegalArgumentException;

    public void iterate(byte[] var1, EntryConsumer var2) throws IOException;

    public MetaStoreIterator<KeyValue> iterator();

    public static class KeyValue {
        private final byte[] key;
        private final byte[] value;

        private KeyValue(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public byte[] getKey() {
            byte[] result = new byte[this.key.length];
            System.arraycopy(this.key, 0, result, 0, this.key.length);
            return result;
        }

        public byte[] getValue() {
            byte[] result = new byte[this.value.length];
            System.arraycopy(this.value, 0, result, 0, this.value.length);
            return result;
        }

        public static KeyValue create(byte[] key, byte[] value) {
            return new KeyValue(key, value);
        }
    }
}

