/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private ScheduledExecutorService scheduler;
    private volatile boolean isClosed;
    private String threadName;

    public Scheduler(String threadName, boolean isDaemon, int numCoreThreads) {
        this.scheduler = Executors.newScheduledThreadPool(numCoreThreads, r -> {
            Thread t = new Thread(r);
            t.setName(threadName);
            t.setDaemon(isDaemon);
            return t;
        });
        this.threadName = threadName;
        this.isClosed = false;
    }

    public void schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.scheduler.schedule(runnable, delay, timeUnit);
    }

    public void schedule(CheckedRunnable runnable, long delay, TimeUnit timeUnit, Logger logger, String errMsg) {
        this.scheduler.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.error(errMsg, throwable);
            }
        }, delay, timeUnit);
    }

    public void scheduleWithFixedDelay(Runnable runnable, long initialDelay, long fixedDelay, TimeUnit timeUnit) {
        this.scheduler.scheduleWithFixedDelay(runnable, initialDelay, fixedDelay, timeUnit);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void close() {
        this.isClosed = true;
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            try {
                this.scheduler.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.info(this.threadName + " interrupted while waiting for task completion {}", (Throwable)e);
            }
        }
        this.scheduler = null;
    }
}

