/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db;

import java.math.BigDecimal;
import org.apache.hadoop.conf.StorageUnit;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.TableFormatConfig;

public enum DBProfile {
    SSD{

        public String toString() {
            return "DBProfile.SSD";
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions() {
            long blockCacheSize = DBProfile.toLong(StorageUnit.MB.toBytes(256.0));
            long blockSize = DBProfile.toLong(StorageUnit.KB.toBytes(16.0));
            long writeBufferSize = DBProfile.toLong(StorageUnit.MB.toBytes(128.0));
            return new ColumnFamilyOptions().setLevelCompactionDynamicLevelBytes(true).setWriteBufferSize(writeBufferSize).setTableFormatConfig((TableFormatConfig)new BlockBasedTableConfig().setBlockCacheSize(blockCacheSize).setBlockSize(blockSize).setCacheIndexAndFilterBlocks(true).setPinL0FilterAndIndexBlocksInCache(true).setFilter((Filter)new BloomFilter()));
        }

        @Override
        public DBOptions getDBOptions() {
            int maxBackgroundCompactions = 4;
            int maxBackgroundFlushes = 2;
            long bytesPerSync = DBProfile.toLong(StorageUnit.MB.toBytes(1.0));
            boolean createIfMissing = true;
            boolean createMissingColumnFamilies = true;
            return new DBOptions().setIncreaseParallelism(Runtime.getRuntime().availableProcessors()).setMaxBackgroundCompactions(4).setMaxBackgroundFlushes(2).setBytesPerSync(bytesPerSync).setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
        }
    }
    ,
    DISK{

        public String toString() {
            return "DBProfile.DISK";
        }

        @Override
        public DBOptions getDBOptions() {
            long readAheadSize = DBProfile.toLong(StorageUnit.MB.toBytes(4.0));
            return SSD.getDBOptions().setCompactionReadaheadSize(readAheadSize);
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions() {
            ColumnFamilyOptions columnFamilyOptions = SSD.getColumnFamilyOptions();
            columnFamilyOptions.setCompactionStyle(CompactionStyle.LEVEL);
            return columnFamilyOptions;
        }
    };


    private static long toLong(double value) {
        BigDecimal temp = new BigDecimal(value);
        return temp.longValue();
    }

    public abstract DBOptions getDBOptions();

    public abstract ColumnFamilyOptions getColumnFamilyOptions();
}

