/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.utils.db.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheResult;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.apache.hadoop.utils.db.cache.EpochEntry;
import org.apache.hadoop.utils.db.cache.TableCache;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TableCacheImpl<CACHEKEY extends CacheKey, CACHEVALUE extends CacheValue>
implements TableCache<CACHEKEY, CACHEVALUE> {
    private final ConcurrentHashMap<CACHEKEY, CACHEVALUE> cache = new ConcurrentHashMap();
    private final TreeSet<EpochEntry<CACHEKEY>> epochEntries = new TreeSet();
    private ExecutorService executorService;
    private CacheCleanupPolicy cleanupPolicy;

    public TableCacheImpl(CacheCleanupPolicy cleanupPolicy) {
        ThreadFactory build = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("PartialTableCache Cleanup Thread - %d").build();
        this.executorService = Executors.newSingleThreadExecutor(build);
        this.cleanupPolicy = cleanupPolicy;
    }

    @Override
    public CACHEVALUE get(CACHEKEY cachekey) {
        return (CACHEVALUE)((CacheValue)this.cache.get(cachekey));
    }

    @Override
    public void put(CACHEKEY cacheKey, CACHEVALUE value) {
        this.cache.put(cacheKey, value);
        this.epochEntries.add(new EpochEntry<CACHEKEY>(((CacheValue)value).getEpoch(), cacheKey));
    }

    @Override
    public void cleanup(long epoch) {
        this.executorService.submit(() -> this.evictCache(epoch, this.cleanupPolicy));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<CACHEKEY, CACHEVALUE>> iterator() {
        return this.cache.entrySet().iterator();
    }

    private void evictCache(long epoch, CacheCleanupPolicy cacheCleanupPolicy) {
        CacheKey cachekey;
        CacheValue cacheValue;
        EpochEntry<CACHEKEY> currentEntry = null;
        Iterator<EpochEntry<CACHEKEY>> iterator = this.epochEntries.iterator();
        while (iterator.hasNext() && ((cacheValue = this.cache.computeIfPresent(cachekey = (CacheKey)(currentEntry = iterator.next()).getCachekey(), (k, v) -> {
            if (this.cleanupPolicy == CacheCleanupPolicy.MANUAL) {
                if (v.getEpoch() <= epoch) {
                    iterator.remove();
                    return null;
                }
            } else if (this.cleanupPolicy == CacheCleanupPolicy.NEVER && v.getEpoch() <= epoch && v.getCacheValue() == null) {
                iterator.remove();
                return null;
            }
            return v;
        })) == null || cacheValue.getEpoch() < epoch)) {
        }
    }

    @Override
    public CacheResult<CACHEVALUE> lookup(CACHEKEY cachekey) {
        if (this.cache.size() == 0) {
            return new CacheResult<Object>(CacheResult.CacheStatus.MAY_EXIST, null);
        }
        CacheValue cachevalue = (CacheValue)this.cache.get(cachekey);
        if (cachevalue == null) {
            if (this.cleanupPolicy == CacheCleanupPolicy.NEVER) {
                return new CacheResult<Object>(CacheResult.CacheStatus.NOT_EXIST, null);
            }
            return new CacheResult<Object>(CacheResult.CacheStatus.MAY_EXIST, null);
        }
        if (cachevalue.getCacheValue() != null) {
            return new CacheResult<CacheValue>(CacheResult.CacheStatus.EXISTS, cachevalue);
        }
        return new CacheResult<Object>(CacheResult.CacheStatus.NOT_EXIST, null);
    }

    public static enum CacheCleanupPolicy {
        NEVER,
        MANUAL;

    }
}

