/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.ratis.raft.server")
public class DatanodeRatisServerConfig {
    public static final String RATIS_SERVER_REQUEST_TIMEOUT_KEY = "rpc.request.timeout";
    public static final String RATIS_SERVER_WATCH_REQUEST_TIMEOUT_KEY = "watch.timeout";
    public static final String RATIS_SERVER_NO_LEADER_TIMEOUT_KEY = "Notification.no-leader.timeout";
    public static final String RATIS_FOLLOWER_SLOWNESS_TIMEOUT_KEY = "rpcslowness.timeout";
    public static final String RATIS_LEADER_NUM_PENDING_REQUESTS_KEY = "write.element-limit";
    @Config(key="rpc.request.timeout", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="The timeout duration of the ratis write request on Ratis Server.")
    private long requestTimeOut = 60000L;
    @Config(key="watch.timeout", defaultValue="180s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="The timeout duration for watch request on Ratis Server. Timeout for the watch request in Ratis server to acknowledge a particular request is replayed to all servers.")
    private long watchTimeOut = 180000L;
    @Config(key="Notification.no-leader.timeout", defaultValue="300s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Time out duration after which StateMachine gets notified that leader has not been elected for a long time and leader changes its role to Candidate.")
    private long noLeaderTimeout = 300000L;
    @Config(key="rpcslowness.timeout", defaultValue="300s", type=ConfigType.TIME, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS}, description="Timeout duration after which stateMachine will be notified that follower is slow. StateMachine will close down the pipeline.")
    private long followerSlownessTimeout = 300000L;
    @Config(key="write.element-limit", defaultValue="1024", type=ConfigType.INT, tags={ConfigTag.OZONE, ConfigTag.DATANODE, ConfigTag.RATIS, ConfigTag.PERFORMANCE}, description="Maximum number of pending requests after which the leader starts rejecting requests from client.")
    private int leaderNumPendingRequests;

    public long getRequestTimeOut() {
        return this.requestTimeOut;
    }

    public void setRequestTimeOut(long requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
    }

    public long getWatchTimeOut() {
        return this.watchTimeOut;
    }

    public void setWatchTimeOut(long watchTimeOut) {
        this.watchTimeOut = watchTimeOut;
    }

    public long getNoLeaderTimeout() {
        return this.noLeaderTimeout;
    }

    public void setNoLeaderTimeout(long noLeaderTimeout) {
        this.noLeaderTimeout = noLeaderTimeout;
    }

    public long getFollowerSlownessTimeout() {
        return this.followerSlownessTimeout;
    }

    public void setFollowerSlownessTimeout(long followerSlownessTimeout) {
        this.followerSlownessTimeout = followerSlownessTimeout;
    }

    public int getLeaderNumPendingRequests() {
        return this.leaderNumPendingRequests;
    }

    public void setLeaderNumPendingRequests(int leaderNumPendingRequests) {
        this.leaderNumPendingRequests = leaderNumPendingRequests;
    }
}

