/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TraceAllMethod<T>
implements InvocationHandler {
    private final Map<String, Map<Class<?>[], Method>> methods = new HashMap<String, Map<Class<?>[], Method>>();
    private T delegate;
    private String name;

    public TraceAllMethod(T delegate, String name) {
        this.delegate = delegate;
        this.name = name;
        for (Method method : delegate.getClass().getDeclaredMethods()) {
            if (!this.methods.containsKey(method.getName())) {
                this.methods.put(method.getName(), new HashMap());
            }
            this.methods.get(method.getName()).put(method.getParameterTypes(), method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method delegateMethod = this.findDelegatedMethod(method);
        if (delegateMethod == null) {
            throw new NoSuchMethodException("Method not found: " + method.getName());
        }
        Throwable throwable = null;
        try (Scope scope = GlobalTracer.get().buildSpan(this.name + "." + method.getName()).startActive(true);){
            Object object = delegateMethod.invoke(this.delegate, args);
            return object;
        }
        catch (Exception ex) {
            try {
                if (ex.getCause() != null) {
                    throw ex.getCause();
                }
                throw ex;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Method findDelegatedMethod(Method method) {
        for (Map.Entry<Class<?>[], Method> entry : this.methods.get(method.getName()).entrySet()) {
            if (!Arrays.equals(entry.getKey(), method.getParameterTypes())) continue;
            return entry.getValue();
        }
        return null;
    }
}

