/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.spi.Extractor;
import io.jaegertracing.spi.Injector;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.tracing.StringCodec;
import org.apache.hadoop.hdds.tracing.TraceAllMethod;

public final class TracingUtil {
    private static final String NULL_SPAN_AS_STRING = "";

    private TracingUtil() {
    }

    public static void initTracing(String serviceName, Configuration conf) {
        if (!GlobalTracer.isRegistered() && TracingUtil.isTracingEnabled(conf)) {
            io.jaegertracing.Configuration config = io.jaegertracing.Configuration.fromEnv((String)serviceName);
            JaegerTracer tracer = config.getTracerBuilder().registerExtractor((Format)StringCodec.FORMAT, (Extractor)new StringCodec()).registerInjector((Format)StringCodec.FORMAT, (Injector)new StringCodec()).build();
            GlobalTracer.register((Tracer)tracer);
        }
    }

    public static String exportCurrentSpan() {
        return TracingUtil.exportSpan(GlobalTracer.get().activeSpan());
    }

    public static String exportSpan(Span span) {
        if (span != null) {
            StringBuilder builder = new StringBuilder();
            GlobalTracer.get().inject(span.context(), (Format)StringCodec.FORMAT, (Object)builder);
            return builder.toString();
        }
        return NULL_SPAN_AS_STRING;
    }

    public static Scope importAndCreateScope(String name, String encodedParent) {
        Tracer tracer = GlobalTracer.get();
        return tracer.buildSpan(name).asChildOf(TracingUtil.extractParent(encodedParent, tracer)).startActive(true);
    }

    private static SpanContext extractParent(String parent, Tracer tracer) {
        if (!GlobalTracer.isRegistered()) {
            return null;
        }
        if (parent == null || parent.isEmpty()) {
            return null;
        }
        return tracer.extract((Format)StringCodec.FORMAT, (Object)new StringBuilder(parent));
    }

    public static <T> T createProxy(T delegate, Class<T> itf, Configuration conf) {
        if (!TracingUtil.isTracingEnabled(conf)) {
            return delegate;
        }
        Class<?> aClass = delegate.getClass();
        return itf.cast(Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{itf}, new TraceAllMethod<T>(delegate, itf.getSimpleName())));
    }

    private static boolean isTracingEnabled(Configuration conf) {
        return conf.getBoolean("hdds.tracing.enabled", true);
    }
}

