/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.lock.ActiveLock;
import org.apache.hadoop.ozone.lock.PooledLockFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager<R> {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final Map<R, ActiveLock> activeLocks = new ConcurrentHashMap<R, ActiveLock>();
    private final GenericObjectPool<ActiveLock> lockPool;

    public LockManager(ConfigurationSource conf) {
        this(conf, false);
    }

    public LockManager(ConfigurationSource conf, boolean fair) {
        this.lockPool = new GenericObjectPool((PooledObjectFactory)new PooledLockFactory(fair));
        this.lockPool.setMaxTotal(-1);
    }

    public void lock(R resource) {
        this.writeLock(resource);
    }

    public void unlock(R resource) {
        this.writeUnlock(resource);
    }

    public void readLock(R resource) {
        this.acquire(resource, ActiveLock::readLock);
    }

    public void readUnlock(R resource) throws IllegalMonitorStateException {
        this.release(resource, ActiveLock::readUnlock);
    }

    public void writeLock(R resource) {
        this.acquire(resource, ActiveLock::writeLock);
    }

    public void writeUnlock(R resource) throws IllegalMonitorStateException {
        this.release(resource, ActiveLock::writeUnlock);
    }

    private void acquire(R resource, Consumer<ActiveLock> lockFn) {
        lockFn.accept(this.getLockForLocking(resource));
    }

    private void release(R resource, Consumer<ActiveLock> releaseFn) {
        ActiveLock lock = this.getLockForReleasing(resource);
        releaseFn.accept(lock);
        this.decrementActiveLockCount(resource);
    }

    private ActiveLock getLockForLocking(R resource) {
        return this.activeLocks.compute(resource, (k, v) -> {
            ActiveLock lock;
            try {
                lock = v == null ? (ActiveLock)this.lockPool.borrowObject() : v;
                lock.incrementActiveCount();
            }
            catch (Exception ex) {
                LOG.error("Unable to obtain lock.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            return lock;
        });
    }

    private ActiveLock getLockForReleasing(R resource) {
        if (this.activeLocks.containsKey(resource)) {
            return this.activeLocks.get(resource);
        }
        LOG.error("Trying to release the lock on {}, which was never acquired.", resource);
        throw new IllegalMonitorStateException("Releasing lock on resource " + resource + " without acquiring lock");
    }

    private void decrementActiveLockCount(R resource) {
        this.activeLocks.computeIfPresent(resource, (k, v) -> {
            v.decrementActiveCount();
            if (v.getActiveLockCount() != 0) {
                return v;
            }
            this.lockPool.returnObject(v);
            return null;
        });
    }
}

