/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.MissingSubcommandException;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import picocli.CommandLine;

public class GenericCli
implements Callable<Void>,
GenericParentCommand {
    @CommandLine.Option(names={"--verbose"}, description={"More verbose output. Show the stack trace of the errors."})
    private boolean verbose;
    @CommandLine.Option(names={"-D", "--set"})
    private Map<String, String> configurationOverrides = new HashMap<String, String>();
    @CommandLine.Option(names={"-conf"})
    private String configurationPath;
    private final CommandLine cmd = new CommandLine((Object)this);

    public GenericCli() {
    }

    public GenericCli(Class<?> type) {
        this();
        this.addSubcommands(this.getCmd(), type);
    }

    private void addSubcommands(CommandLine cli, Class<?> type) {
        ServiceLoader<SubcommandWithParent> registeredSubcommands = ServiceLoader.load(SubcommandWithParent.class);
        for (SubcommandWithParent subcommand : registeredSubcommands) {
            if (!subcommand.getParentType().equals(type)) continue;
            CommandLine.Command commandAnnotation = subcommand.getClass().getAnnotation(CommandLine.Command.class);
            CommandLine subcommandCommandLine = new CommandLine((Object)subcommand);
            this.addSubcommands(subcommandCommandLine, subcommand.getClass());
            cli.addSubcommand(commandAnnotation.name(), (Object)subcommandCommandLine);
        }
    }

    public static void missingSubcommand(CommandLine.Model.CommandSpec spec) {
        System.err.println("Incomplete command");
        spec.commandLine().usage(System.err);
        System.exit(-1);
    }

    public void run(String[] argv) {
        try {
            this.execute(argv);
        }
        catch (CommandLine.ExecutionException ex) {
            this.printError(ex.getCause() == null ? ex : ex.getCause());
            System.exit(-1);
        }
    }

    @VisibleForTesting
    public void execute(String[] argv) {
        this.cmd.parseWithHandler((CommandLine.IParseResultHandler2)new CommandLine.RunLast(), argv);
    }

    protected void printError(Throwable error) {
        if (this.verbose || error.getMessage() == null || error.getMessage().length() == 0) {
            error.printStackTrace(System.err);
        } else {
            System.err.println(error.getMessage().split("\n")[0]);
        }
    }

    @Override
    public Void call() throws Exception {
        throw new MissingSubcommandException(this.cmd);
    }

    @Override
    public OzoneConfiguration createOzoneConfiguration() {
        OzoneConfiguration ozoneConf = new OzoneConfiguration();
        if (this.configurationPath != null) {
            ozoneConf.addResource(new Path(this.configurationPath));
        }
        if (this.configurationOverrides != null) {
            for (Map.Entry<String, String> entry : this.configurationOverrides.entrySet()) {
                ozoneConf.set(entry.getKey(), entry.getValue());
            }
        }
        return ozoneConf;
    }

    @VisibleForTesting
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }
}

