/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.ConfigurationTarget;
import org.apache.hadoop.hdds.conf.PostConstruct;

public final class ConfigurationReflectionUtil {
    private ConfigurationReflectionUtil() {
    }

    public static <T> void injectConfiguration(ConfigurationSource configuration, Class<T> configurationClass, T configObject, String prefix) {
        ConfigurationReflectionUtil.injectConfigurationToObject(configuration, configurationClass, configObject, prefix);
        for (Class<T> superClass = configurationClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            ConfigurationReflectionUtil.injectConfigurationToObject(configuration, superClass, configObject, prefix);
        }
    }

    public static <T> void injectConfigurationToObject(ConfigurationSource from, Class<T> configurationClass, T configuration, String prefix) {
        for (Field field : configurationClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            if ((field.getModifiers() & 0x10) != 0) {
                throw new ConfigurationException(String.format("Trying to set final field %s#%s, probably indicates misplaced @Config annotation", configurationClass.getSimpleName(), field.getName()));
            }
            String fieldLocation = configurationClass + "." + field.getName();
            Config configAnnotation = field.getAnnotation(Config.class);
            String key = prefix + "." + configAnnotation.key();
            ConfigType type = configAnnotation.type();
            if (type == ConfigType.AUTO) {
                type = ConfigurationReflectionUtil.detectConfigType(field.getType(), fieldLocation);
            }
            try {
                switch (type) {
                    case STRING: {
                        ConfigurationReflectionUtil.forcedFieldSet(field, configuration, from.get(key));
                        break;
                    }
                    case INT: {
                        ConfigurationReflectionUtil.forcedFieldSet(field, configuration, from.getInt(key, 0));
                        break;
                    }
                    case BOOLEAN: {
                        ConfigurationReflectionUtil.forcedFieldSet(field, configuration, from.getBoolean(key, false));
                        break;
                    }
                    case LONG: {
                        ConfigurationReflectionUtil.forcedFieldSet(field, configuration, from.getLong(key, 0L));
                        break;
                    }
                    case TIME: {
                        ConfigurationReflectionUtil.forcedFieldSet(field, configuration, from.getTimeDuration(key, "0s", configAnnotation.timeUnit()));
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Unsupported ConfigType " + (Object)((Object)type) + " on " + fieldLocation);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Can't inject configuration to " + fieldLocation, e);
            }
        }
    }

    private static <T> void forcedFieldSet(Field field, T object, Object value) throws IllegalAccessException {
        boolean accessChanged = false;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            accessChanged = true;
        }
        field.set(object, value);
        if (accessChanged) {
            field.setAccessible(false);
        }
    }

    private static ConfigType detectConfigType(Class<?> parameterType, String methodLocation) {
        ConfigType type;
        if (parameterType == String.class) {
            type = ConfigType.STRING;
        } else if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            type = ConfigType.INT;
        } else if (parameterType == Long.class || parameterType == Long.TYPE) {
            type = ConfigType.LONG;
        } else if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
            type = ConfigType.BOOLEAN;
        } else {
            throw new ConfigurationException("Unsupported configuration type " + parameterType + " in " + methodLocation);
        }
        return type;
    }

    public static <T> void callPostConstruct(Class<T> configurationClass, T configObject) {
        for (Method method : configurationClass.getMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            try {
                method.invoke(configObject, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("@PostConstruct method in " + configurationClass + " is not accessible");
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IllegalArgumentException("@PostConstruct can't be executed on " + configurationClass + " after configObject injection", e);
            }
        }
    }

    public static <T> void updateConfiguration(ConfigurationTarget config, T object, String prefix) {
        Class<?> configClass = object.getClass();
        LinkedList classes = new LinkedList();
        classes.addLast(configClass);
        for (Class<?> superclass = configClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.addFirst(superclass);
        }
        for (Class clazz : classes) {
            ConfigurationReflectionUtil.updateConfigurationFromObject(config, clazz, object, prefix);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <T> void updateConfigurationFromObject(ConfigurationTarget config, Class<?> configClass, T configObject, String prefix) {
        block12: for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            configAnnotation = field.getAnnotation(Config.class);
            fieldLocation = configClass + "." + field.getName();
            key = prefix + "." + configAnnotation.key();
            type = configAnnotation.type();
            if (type == ConfigType.AUTO) {
                type = ConfigurationReflectionUtil.detectConfigType(field.getType(), fieldLocation);
            }
            accessChanged = false;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                    accessChanged = true;
                }
                switch (1.$SwitchMap$org$apache$hadoop$hdds$conf$ConfigType[type.ordinal()]) {
                    case 1: {
                        value = field.get(configObject);
                        if (value == null) continue block12;
                        config.set(key, String.valueOf(value));
                        ** break;
lbl20:
                        // 1 sources

                        continue block12;
                    }
                    case 2: {
                        config.setInt(key, field.getInt(configObject));
                        ** break;
lbl24:
                        // 1 sources

                        continue block12;
                    }
                    case 3: {
                        config.setBoolean(key, field.getBoolean(configObject));
                        ** break;
lbl28:
                        // 1 sources

                        continue block12;
                    }
                    case 4: {
                        config.setLong(key, field.getLong(configObject));
                        ** break;
lbl32:
                        // 1 sources

                        continue block12;
                    }
                    case 5: {
                        config.setTimeDuration(key, field.getLong(configObject), configAnnotation.timeUnit());
                        ** break;
lbl36:
                        // 1 sources

                        continue block12;
                    }
                    default: {
                        throw new ConfigurationException("Unsupported ConfigType " + (Object)type + " on " + fieldLocation);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Can't inject configuration to " + fieldLocation, e);
            }
            finally {
                if (accessChanged) {
                    field.setAccessible(false);
                }
            }
        }
    }
}

