/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigurationReflectionUtil;
import org.apache.hadoop.hdds.conf.TimeDurationUtil;

public interface ConfigurationTarget {
    public void set(String var1, String var2);

    default public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    default public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    default public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    default public void setTimeDuration(String name, long value, TimeUnit unit) {
        this.set(name, value + TimeDurationUtil.ParsedTimeDuration.unitFor(unit).suffix());
    }

    default public <T> void setFromObject(T object) {
        ConfigGroup configGroup = object.getClass().getAnnotation(ConfigGroup.class);
        String prefix = configGroup.prefix();
        ConfigurationReflectionUtil.updateConfiguration(this, object, prefix);
    }
}

