/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.DefaultCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exceptions.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMCertificateClient
extends DefaultCertificateClient {
    private static final Logger LOG = LoggerFactory.getLogger(OMCertificateClient.class);
    public static final String COMPONENT_NAME = "om";

    public OMCertificateClient(SecurityConfig securityConfig, String certSerialId) {
        super(securityConfig, LOG, certSerialId, COMPONENT_NAME);
    }

    public OMCertificateClient(SecurityConfig securityConfig) {
        super(securityConfig, LOG, null, COMPONENT_NAME);
    }

    @Override
    protected CertificateClient.InitResponse handleCase(DefaultCertificateClient.InitCase init) throws CertificateException {
        switch (init) {
            case NONE: {
                LOG.info("Creating keypair for client as keypair and certificate not found.");
                this.bootstrapClientKeys();
                return CertificateClient.InitResponse.GETCERT;
            }
            case CERT: {
                LOG.error("Private key not found, while certificate is still present.Delete keypair and try again.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case PUBLIC_KEY: {
                LOG.error("Found public key but private key and certificate missing.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case PRIVATE_KEY: {
                LOG.info("Found private key but public key and certificate is missing.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case PUBLICKEY_CERT: {
                LOG.error("Found public key and certificate but private key is missing.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case PRIVATEKEY_CERT: {
                LOG.info("Found private key and certificate but public key missing.");
                if (this.recoverPublicKey()) {
                    return CertificateClient.InitResponse.SUCCESS;
                }
                LOG.error("Public key recovery failed.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case PUBLICKEY_PRIVATEKEY: {
                LOG.info("Found private and public key but certificate is missing.");
                if (this.validateKeyPair(this.getPublicKey())) {
                    return CertificateClient.InitResponse.RECOVER;
                }
                LOG.error("Keypair validation failed.");
                return CertificateClient.InitResponse.FAILURE;
            }
            case ALL: {
                LOG.info("Found certificate file along with KeyPair.");
                if (this.validateKeyPairAndCertificate()) {
                    return CertificateClient.InitResponse.SUCCESS;
                }
                return CertificateClient.InitResponse.FAILURE;
            }
        }
        LOG.error("Unexpected case: {} (private/public/cert)", (Object)Integer.toBinaryString(init.ordinal()));
        return CertificateClient.InitResponse.FAILURE;
    }

    @Override
    public CertificateSignRequest.Builder getCSRBuilder() throws CertificateException {
        return super.getCSRBuilder().setDigitalEncryption(true).setDigitalSignature(true);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }
}

