/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.ByteArrayKeyValue;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBMetrics;
import org.apache.hadoop.hdds.utils.db.RDBStoreIterator;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Holder;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RDBTable
implements Table<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(RDBTable.class);
    private final RocksDB db;
    private final ColumnFamilyHandle handle;
    private final WriteOptions writeOptions;
    private final RDBMetrics rdbMetrics;

    RDBTable(RocksDB db, ColumnFamilyHandle handle, WriteOptions writeOptions, RDBMetrics rdbMetrics) {
        this.db = db;
        this.handle = handle;
        this.writeOptions = writeOptions;
        this.rdbMetrics = rdbMetrics;
    }

    public ColumnFamilyHandle getHandle() {
        return this.handle;
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.handle, this.writeOptions, key, value);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to write to DB. Key: {}", (Object)new String(key, StandardCharsets.UTF_8));
            throw HddsServerUtil.toIOException("Failed to put key-value to metadata store", e);
        }
    }

    @Override
    public void putWithBatch(BatchOperation batch, byte[] key, byte[] value) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).put(this.getHandle(), key, value);
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (TableIterator<byte[], ByteArrayKeyValue> keyIter = this.iterator();){
            keyIter.seekToFirst();
            boolean bl = !keyIter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean isExist(byte[] key) throws IOException {
        try {
            this.rdbMetrics.incNumDBKeyMayExistChecks();
            Holder outValue = new Holder();
            boolean keyMayExist = this.db.keyMayExist(this.handle, key, outValue);
            if (keyMayExist) {
                boolean keyExists;
                boolean bl = keyExists = outValue.getValue() != null && ((byte[])outValue.getValue()).length > 0 || this.db.get(this.handle, key) != null;
                if (!keyExists) {
                    this.rdbMetrics.incNumDBKeyMayExistMisses();
                }
                return keyExists;
            }
            return false;
        }
        catch (RocksDBException e) {
            throw HddsServerUtil.toIOException("Error in accessing DB. ", e);
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(this.handle, key);
        }
        catch (RocksDBException e) {
            throw HddsServerUtil.toIOException("Failed to get the value for the given key", e);
        }
    }

    @Override
    public byte[] getSkipCache(byte[] bytes) throws IOException {
        return this.get(bytes);
    }

    @Override
    public byte[] getIfExist(byte[] key) throws IOException {
        try {
            this.rdbMetrics.incNumDBKeyGetIfExistChecks();
            boolean keyMayExist = this.db.keyMayExist(this.handle, key, null);
            if (keyMayExist) {
                this.rdbMetrics.incNumDBKeyGetIfExistGets();
                byte[] val = this.db.get(this.handle, key);
                if (val == null) {
                    this.rdbMetrics.incNumDBKeyGetIfExistMisses();
                }
                return val;
            }
            return null;
        }
        catch (RocksDBException e) {
            throw HddsServerUtil.toIOException("Error in accessing DB. ", e);
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(this.handle, key);
        }
        catch (RocksDBException e) {
            throw HddsServerUtil.toIOException("Failed to delete the given key", e);
        }
    }

    @Override
    public void deleteWithBatch(BatchOperation batch, byte[] key) throws IOException {
        if (!(batch instanceof RDBBatchOperation)) {
            throw new IllegalArgumentException("batch should be RDBBatchOperation");
        }
        ((RDBBatchOperation)batch).delete(this.getHandle(), key);
    }

    @Override
    public TableIterator<byte[], ByteArrayKeyValue> iterator() {
        ReadOptions readOptions = new ReadOptions();
        readOptions.setFillCache(false);
        return new RDBStoreIterator(this.db.newIterator(this.handle, readOptions), this);
    }

    @Override
    public String getName() throws IOException {
        try {
            return StringUtils.bytes2String((byte[])this.getHandle().getName());
        }
        catch (RocksDBException rdbEx) {
            throw HddsServerUtil.toIOException("Unable to get the table name.", rdbEx);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public long getEstimatedKeyCount() throws IOException {
        try {
            return this.db.getLongProperty(this.handle, "rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw HddsServerUtil.toIOException("Failed to get estimated key count of table " + this.getName(), e);
        }
    }

    @Override
    public List<ByteArrayKeyValue> getRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, false, filters);
    }

    @Override
    public List<ByteArrayKeyValue> getSequentialRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, true, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ByteArrayKeyValue> getRangeKVs(byte[] startKey, int count, boolean sequential, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        block27: {
            block28: {
                block31: {
                    result = new ArrayList<ByteArrayKeyValue>();
                    start = System.currentTimeMillis();
                    if (count < 0) {
                        throw new IllegalArgumentException("Invalid count given " + count + ", count must be greater than 0");
                    }
                    try {
                        block29: {
                            block30: {
                                it = this.db.newIterator(this.handle);
                                var9_9 = null;
                                try {
                                    if (startKey == null) {
                                        it.seekToFirst();
                                    } else {
                                        if (this.get(startKey) != null) break block27;
                                        var10_10 = result;
                                        if (it == null) break block28;
                                        if (var9_9 == null) break block29;
                                        break block30;
                                    }
lbl17:
                                    // 2 sources

                                    while (true) {
                                        if (!it.isValid() || result.size() >= count) break block31;
                                        currentKey = it.key();
                                        currentValue = it.value();
                                        it.prev();
                                        prevKey = it.isValid() != false ? it.key() : null;
                                        it.seek(currentKey);
                                        it.next();
                                        v0 = nextKey = it.isValid() != false ? it.key() : null;
                                        if (filters == null) {
                                            result.add(ByteArrayKeyValue.create(currentKey, currentValue));
                                            continue;
                                        }
                                        if (Arrays.stream(filters).allMatch((Predicate<MetadataKeyFilters.MetadataKeyFilter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRangeKVs$0(byte[] byte[] byte[] org.apache.hadoop.hdds.utils.MetadataKeyFilters$MetadataKeyFilter ), (Lorg/apache/hadoop/hdds/utils/MetadataKeyFilters$MetadataKeyFilter;)Z)((byte[])prevKey, (byte[])currentKey, (byte[])nextKey))) {
                                            result.add(ByteArrayKeyValue.create(currentKey, currentValue));
                                            continue;
                                        }
                                        if (result.size() <= 0 || !sequential) continue;
                                        break block31;
                                        break;
                                    }
                                }
                                catch (Throwable currentKey) {
                                    var9_9 = currentKey;
                                    throw currentKey;
                                }
                                catch (Throwable var21_31) {
                                    throw var21_31;
                                }
                            }
                            try {
                                it.close();
                            }
                            catch (Throwable var11_15) {
                                var9_9.addSuppressed(var11_15);
                            }
                            break block28;
                        }
                        it.close();
                    }
                    catch (Throwable var23_34) {
                        end = System.currentTimeMillis();
                        timeConsumed = end - start;
                        if (RDBTable.LOG.isDebugEnabled() == false) throw var23_34;
                        if (filters != null) {
                            for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                                scanned = filter.getKeysScannedNum();
                                hinted = filter.getKeysHintedNum();
                                if (scanned <= 0 && hinted <= 0) continue;
                                RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                            }
                        }
                        RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                        throw var23_34;
                    }
                }
                end = System.currentTimeMillis();
                timeConsumed = end - start;
                if (RDBTable.LOG.isDebugEnabled() == false) return result;
                if (filters != null) {
                    for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                        scanned = filter.getKeysScannedNum();
                        hinted = filter.getKeysHintedNum();
                        if (scanned <= 0 && hinted <= 0) continue;
                        RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                    }
                }
                RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                return result;
            }
            end = System.currentTimeMillis();
            timeConsumed = end - start;
            if (RDBTable.LOG.isDebugEnabled() == false) return var10_10;
            if (filters != null) {
                for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                    scanned = filter.getKeysScannedNum();
                    hinted = filter.getKeysHintedNum();
                    if (scanned <= 0 && hinted <= 0) continue;
                    RDBTable.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                }
            }
            RDBTable.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
            return var10_10;
        }
        it.seek(startKey);
        ** while (true)
    }

    private static /* synthetic */ boolean lambda$getRangeKVs$0(byte[] prevKey, byte[] currentKey, byte[] nextKey, MetadataKeyFilters.MetadataKeyFilter entry) {
        return entry.filterKey(prevKey, currentKey, nextKey);
    }
}

