/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheResult;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.EpochEntry;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FullTableCache<CACHEKEY extends CacheKey, CACHEVALUE extends CacheValue>
implements TableCache<CACHEKEY, CACHEVALUE> {
    public static final Logger LOG = LoggerFactory.getLogger(FullTableCache.class);
    private final Map<CACHEKEY, CACHEVALUE> cache = new ConcurrentSkipListMap<CACHEKEY, CACHEVALUE>();
    private final NavigableSet<EpochEntry<CACHEKEY>> epochEntries;
    private ExecutorService executorService;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public FullTableCache() {
        this.epochEntries = new ConcurrentSkipListSet<EpochEntry<CACHEKEY>>();
        ThreadFactory build = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FullTableCache Cleanup Thread - %d").build();
        this.executorService = Executors.newSingleThreadExecutor(build);
    }

    @Override
    public CACHEVALUE get(CACHEKEY cachekey) {
        try {
            this.lock.readLock().lock();
            CacheValue cacheValue = (CacheValue)this.cache.get(cachekey);
            return (CACHEVALUE)cacheValue;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void loadInitial(CACHEKEY cacheKey, CACHEVALUE cacheValue) {
        this.cache.put(cacheKey, cacheValue);
    }

    @Override
    public void put(CACHEKEY cacheKey, CACHEVALUE value) {
        try {
            this.lock.writeLock().lock();
            this.cache.put(cacheKey, value);
            this.epochEntries.add(new EpochEntry<CACHEKEY>(((CacheValue)value).getEpoch(), cacheKey));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void cleanup(List<Long> epochs) {
        this.executorService.execute(() -> this.evictCache(epochs));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Iterator<Map.Entry<CACHEKEY, CACHEVALUE>> iterator() {
        return this.cache.entrySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void evictCache(List<Long> epochs) {
        long lastEpoch = epochs.get(epochs.size() - 1);
        Iterator<EpochEntry<CACHEKEY>> iterator = this.epochEntries.iterator();
        while (iterator.hasNext()) {
            EpochEntry<CACHEKEY> currentEntry = iterator.next();
            CacheKey cachekey = (CacheKey)currentEntry.getCachekey();
            long currentEpoch = currentEntry.getEpoch();
            if (currentEpoch > lastEpoch) break;
            try {
                this.lock.writeLock().lock();
                if (!epochs.contains(currentEpoch)) continue;
                iterator.remove();
                this.cache.computeIfPresent(cachekey, (k, v) -> {
                    if (v.getCacheValue() == null && v.getEpoch() == currentEpoch) {
                        LOG.debug("CacheKey {} with epoch {} is removed from cache", k.getCacheKey(), (Object)currentEpoch);
                        return null;
                    }
                    return v;
                });
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public CacheResult<CACHEVALUE> lookup(CACHEKEY cachekey) {
        CacheValue cachevalue = (CacheValue)this.cache.get(cachekey);
        if (cachevalue == null) {
            return new CacheResult<Object>(CacheResult.CacheStatus.NOT_EXIST, null);
        }
        if (cachevalue.getCacheValue() != null) {
            return new CacheResult<CacheValue>(CacheResult.CacheStatus.EXISTS, cachevalue);
        }
        return new CacheResult<Object>(CacheResult.CacheStatus.NOT_EXIST, null);
    }

    @Override
    @VisibleForTesting
    public Set<EpochEntry<CACHEKEY>> getEpochEntrySet() {
        return this.epochEntries;
    }
}

