/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.io.File;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.chillmode.Precheck;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScmUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ScmUtils.class);

    private ScmUtils() {
    }

    public static void preCheck(HddsProtos.ScmOps operation, Precheck ... preChecks) throws SCMException {
        for (Precheck preCheck : preChecks) {
            preCheck.check(operation);
        }
    }

    public static File getDBPath(Configuration conf, String dbDirectory) {
        Collection dbDirs = conf.getTrimmedStringCollection(dbDirectory);
        if (dbDirs.size() > 1) {
            throw new IllegalArgumentException("Bad configuration setting " + dbDirectory + ". OM does not support multiple metadata dirs currently.");
        }
        if (dbDirs.size() == 1) {
            File dbDirPath = new File((String)dbDirs.iterator().next());
            if (!dbDirPath.exists() && !dbDirPath.mkdirs()) {
                throw new IllegalArgumentException("Unable to create directory " + dbDirPath + " specified in configuration setting " + dbDirectory);
            }
            return dbDirPath;
        }
        LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)dbDirectory, (Object)"ozone.metadata.dirs");
        return ServerUtils.getOzoneMetaDirPath((Configuration)conf);
    }
}

