/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeExitRule;
import org.apache.hadoop.hdds.scm.chillmode.SCMChillModeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyPipelineChillModeRule
implements ChillModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode>,
EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(HealthyPipelineChillModeRule.class);
    private final PipelineManager pipelineManager;
    private final SCMChillModeManager chillModeManager;
    private final int healthyPipelineThresholdCount;
    private int currentHealthyPipelineCount = 0;
    private final Set<DatanodeDetails> processedDatanodeDetails = new HashSet<DatanodeDetails>();

    HealthyPipelineChillModeRule(PipelineManager pipelineManager, SCMChillModeManager manager, Configuration configuration) {
        this.pipelineManager = pipelineManager;
        this.chillModeManager = manager;
        double healthyPipelinesPercent = configuration.getDouble("hdds.scm.chillmode.healthy.pipelie.pct", 0.1);
        int pipelineCount = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size();
        this.healthyPipelineThresholdCount = (int)Math.ceil(healthyPipelinesPercent * (double)pipelineCount);
        LOG.info(" Total pipeline count is {}, healthy pipeline threshold count is {}", (Object)pipelineCount, (Object)this.healthyPipelineThresholdCount);
    }

    @Override
    public boolean validate() {
        return this.currentHealthyPipelineCount >= this.healthyPipelineThresholdCount;
    }

    @Override
    public void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
            Pipeline pipeline;
            PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
            try {
                pipeline = this.pipelineManager.getPipeline(pipelineID);
            }
            catch (PipelineNotFoundException e) {
                continue;
            }
            if (pipeline.getFactor() != HddsProtos.ReplicationFactor.THREE || pipeline.getPipelineState() != Pipeline.PipelineState.OPEN) continue;
            ++this.currentHealthyPipelineCount;
        }
    }

    @Override
    public void cleanup() {
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode, EventPublisher publisher) {
        if (this.validate()) {
            this.chillModeManager.validateChillModeExitRules(publisher);
            return;
        }
        DatanodeDetails dnDetails = pipelineReportFromDatanode.getDatanodeDetails();
        if (!this.processedDatanodeDetails.contains(pipelineReportFromDatanode.getDatanodeDetails())) {
            this.process(pipelineReportFromDatanode);
            if (this.chillModeManager.getInChillMode()) {
                SCMChillModeManager.getLogger().info("SCM in chill mode. Healthy pipelines reported count is {}, required healthy pipeline reported count is {}", (Object)this.currentHealthyPipelineCount, (Object)this.healthyPipelineThresholdCount);
            }
            this.processedDatanodeDetails.add(dnDetails);
        }
        if (this.validate()) {
            this.chillModeManager.validateChillModeExitRules(publisher);
        }
    }
}

