/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.chillmode;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.chillmode.ChillModeExitRule;
import org.apache.hadoop.hdds.scm.chillmode.ContainerChillModeRule;
import org.apache.hadoop.hdds.scm.chillmode.DataNodeChillModeRule;
import org.apache.hadoop.hdds.scm.chillmode.HealthyPipelineChillModeRule;
import org.apache.hadoop.hdds.scm.chillmode.OneReplicaPipelineChillModeRule;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMChillModeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMChillModeManager.class);
    private final boolean isChillModeEnabled;
    private AtomicBoolean inChillMode = new AtomicBoolean(true);
    private Map<String, ChillModeExitRule> exitRules = new HashMap<String, ChillModeExitRule>(1);
    private Configuration config;
    private static final String CONT_EXIT_RULE = "ContainerChillModeRule";
    private static final String DN_EXIT_RULE = "DataNodeChillModeRule";
    private static final String HEALTHY_PIPELINE_EXIT_RULE = "HealthyPipelineChillModeRule";
    private static final String ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE = "AtleastOneDatanodeReportedRule";
    private final EventQueue eventPublisher;
    private final PipelineManager pipelineManager;

    public SCMChillModeManager(Configuration conf, List<ContainerInfo> allContainers, PipelineManager pipelineManager, EventQueue eventQueue) {
        this.config = conf;
        this.pipelineManager = pipelineManager;
        this.eventPublisher = eventQueue;
        this.isChillModeEnabled = conf.getBoolean("hdds.scm.chillmode.enabled", true);
        if (this.isChillModeEnabled) {
            ContainerChillModeRule containerChillModeRule = new ContainerChillModeRule(this.config, allContainers, this);
            DataNodeChillModeRule dataNodeChillModeRule = new DataNodeChillModeRule(this.config, this);
            this.exitRules.put(CONT_EXIT_RULE, containerChillModeRule);
            this.exitRules.put(DN_EXIT_RULE, dataNodeChillModeRule);
            this.eventPublisher.addHandler(SCMEvents.NODE_REGISTRATION_CONT_REPORT, (EventHandler)containerChillModeRule);
            this.eventPublisher.addHandler(SCMEvents.NODE_REGISTRATION_CONT_REPORT, (EventHandler)dataNodeChillModeRule);
            if (conf.getBoolean("hdds.scm.chillmode.pipeline-availability.check", false) && pipelineManager != null) {
                HealthyPipelineChillModeRule rule = new HealthyPipelineChillModeRule(pipelineManager, this, this.config);
                OneReplicaPipelineChillModeRule oneReplicaPipelineChillModeRule = new OneReplicaPipelineChillModeRule(pipelineManager, this, conf);
                this.exitRules.put(HEALTHY_PIPELINE_EXIT_RULE, rule);
                this.exitRules.put(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE, oneReplicaPipelineChillModeRule);
                this.eventPublisher.addHandler(SCMEvents.PROCESSED_PIPELINE_REPORT, (EventHandler)rule);
                this.eventPublisher.addHandler(SCMEvents.PROCESSED_PIPELINE_REPORT, (EventHandler)oneReplicaPipelineChillModeRule);
            }
            this.emitChillModeStatus();
        } else {
            this.exitChillMode((EventPublisher)eventQueue);
        }
    }

    @VisibleForTesting
    public void emitChillModeStatus() {
        this.eventPublisher.fireEvent(SCMEvents.CHILL_MODE_STATUS, (Object)this.getInChillMode());
    }

    public void validateChillModeExitRules(EventPublisher eventQueue) {
        for (ChillModeExitRule exitRule : this.exitRules.values()) {
            if (exitRule.validate()) continue;
            return;
        }
        this.exitChillMode(eventQueue);
    }

    @VisibleForTesting
    public void exitChillMode(EventPublisher eventQueue) {
        LOG.info("SCM exiting chill mode.");
        this.setInChillMode(false);
        for (ChillModeExitRule e : this.exitRules.values()) {
            e.cleanup();
        }
        this.emitChillModeStatus();
        this.pipelineManager.startPipelineCreator();
    }

    public boolean getInChillMode() {
        if (!this.isChillModeEnabled) {
            return false;
        }
        return this.inChillMode.get();
    }

    public void setInChillMode(boolean inChillMode) {
        this.inChillMode.set(inChillMode);
    }

    public static Logger getLogger() {
        return LOG;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return ((ContainerChillModeRule)this.exitRules.get(CONT_EXIT_RULE)).getCurrentContainerThreshold();
    }

    @VisibleForTesting
    public HealthyPipelineChillModeRule getHealthyPipelineChillModeRule() {
        return (HealthyPipelineChillModeRule)this.exitRules.get(HEALTHY_PIPELINE_EXIT_RULE);
    }

    @VisibleForTesting
    public OneReplicaPipelineChillModeRule getOneReplicaPipelineChillModeRule() {
        return (OneReplicaPipelineChillModeRule)this.exitRules.get(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE);
    }
}

