/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.PendingDeleteStatusList;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.ReportHandlerHelper;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationActivityStatus;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationRequest;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final NodeManager nodeManager;
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final ReplicationActivityStatus replicationStatus;

    public ContainerReportHandler(NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager, ReplicationActivityStatus replicationActivityStatus) {
        Preconditions.checkNotNull((Object)nodeManager);
        Preconditions.checkNotNull((Object)pipelineManager);
        Preconditions.checkNotNull((Object)containerManager);
        Preconditions.checkNotNull((Object)replicationActivityStatus);
        this.nodeManager = nodeManager;
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.replicationStatus = replicationActivityStatus;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        DatanodeDetails datanodeDetails = reportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        try {
            List replicas = containerReport.getReportsList();
            Set<ContainerID> expectedContainerIDs = this.nodeManager.getContainers(datanodeDetails);
            Set<ContainerID> actualContainerIDs = replicas.parallelStream().map(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto::getContainerID).map(ContainerID::valueof).collect(Collectors.toSet());
            HashSet<ContainerID> newReplicas = new HashSet<ContainerID>(actualContainerIDs);
            newReplicas.removeAll(expectedContainerIDs);
            HashSet<ContainerID> missingReplicas = new HashSet<ContainerID>(expectedContainerIDs);
            missingReplicas.removeAll(actualContainerIDs);
            this.processContainerReplicas(datanodeDetails, replicas, publisher);
            for (ContainerID id2 : missingReplicas) {
                try {
                    this.containerManager.getContainerReplicas(id2).stream().filter(replica -> replica.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                        try {
                            this.containerManager.removeContainerReplica(id2, (ContainerReplica)replica);
                        }
                        catch (ContainerNotFoundException | ContainerReplicaNotFoundException throwable) {
                            // empty catch block
                        }
                    });
                }
                catch (ContainerNotFoundException e) {
                    LOG.warn("Cannot remove container replica, container {} not found {}", (Object)id2, (Object)e);
                }
            }
            this.nodeManager.setContainers(datanodeDetails, actualContainerIDs);
            newReplicas.forEach(id -> this.checkReplicationState((ContainerID)id, publisher));
            missingReplicas.forEach(id -> this.checkReplicationState((ContainerID)id, publisher));
        }
        catch (NodeNotFoundException ex) {
            LOG.error("Received container report from unknown datanode {} {}", (Object)datanodeDetails, (Object)ex);
        }
    }

    private void processContainerReplicas(DatanodeDetails datanodeDetails, List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> replicas, EventPublisher publisher) {
        PendingDeleteStatusList pendingDeleteStatusList = new PendingDeleteStatusList(datanodeDetails);
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : replicas) {
            try {
                ContainerID containerID = ContainerID.valueof((long)replicaProto.getContainerID());
                ReportHandlerHelper.processContainerReplica(this.containerManager, containerID, replicaProto, datanodeDetails, publisher, LOG);
                ContainerInfo containerInfo = this.containerManager.getContainer(containerID);
                if (containerInfo.getDeleteTransactionId() <= replicaProto.getDeleteTransactionId()) continue;
                pendingDeleteStatusList.addPendingDeleteStatus(replicaProto.getDeleteTransactionId(), containerInfo.getDeleteTransactionId(), containerInfo.getContainerID());
            }
            catch (ContainerNotFoundException e) {
                LOG.error("Received container report for an unknown container {} from datanode {} {}", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
            }
            catch (IOException e) {
                LOG.error("Exception while processing container report for container {} from datanode {} {}", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
            }
        }
        if (pendingDeleteStatusList.getNumPendingDeletes() > 0) {
            publisher.fireEvent(SCMEvents.PENDING_DELETE_STATUS, (Object)pendingDeleteStatusList);
        }
    }

    private void checkReplicationState(ContainerID containerID, EventPublisher publisher) {
        try {
            ContainerInfo container = this.containerManager.getContainer(containerID);
            this.replicateIfNeeded(container, publisher);
        }
        catch (ContainerNotFoundException ex) {
            LOG.warn("Container is missing from containerStateManager. Can't request replication. {} {}", (Object)containerID, (Object)ex);
        }
    }

    private void replicateIfNeeded(ContainerInfo container, EventPublisher publisher) throws ContainerNotFoundException {
        int expectedReplicas;
        int existingReplicas;
        if (!container.isOpen() && this.replicationStatus.isReplicationEnabled() && (existingReplicas = this.containerManager.getContainerReplicas(container.containerID()).size()) != (expectedReplicas = container.getReplicationFactor().getNumber())) {
            publisher.fireEvent(SCMEvents.REPLICATE_CONTAINER, (Object)new ReplicationRequest(container.getContainerID(), existingReplicas, expectedReplicas));
        }
    }
}

