/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.container.states.ContainerState;
import org.apache.hadoop.hdds.scm.container.states.ContainerStateMap;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerStateManager.class);
    private final StateMachine<HddsProtos.LifeCycleState, HddsProtos.LifeCycleEvent> stateMachine;
    private final long containerSize;
    private final ConcurrentHashMap<ContainerState, ContainerID> lastUsedMap;
    private final ContainerStateMap containers;
    private final AtomicLong containerCount;

    public ContainerStateManager(Configuration configuration) {
        HashSet<HddsProtos.LifeCycleState> finalStates = new HashSet<HddsProtos.LifeCycleState>();
        finalStates.add(HddsProtos.LifeCycleState.OPEN);
        finalStates.add(HddsProtos.LifeCycleState.CLOSED);
        finalStates.add(HddsProtos.LifeCycleState.DELETED);
        this.stateMachine = new StateMachine((Enum)HddsProtos.LifeCycleState.OPEN, finalStates);
        this.initializeStateMachine();
        this.containerSize = (long)configuration.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.lastUsedMap = new ConcurrentHashMap();
        this.containerCount = new AtomicLong(0L);
        this.containers = new ContainerStateMap();
    }

    private void initializeStateMachine() {
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.OPEN, (Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleEvent.FINALIZE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.QUASI_CLOSED, (Enum)HddsProtos.LifeCycleEvent.QUASI_CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSING, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.QUASI_CLOSED, (Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleEvent.FORCE_CLOSE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.CLOSED, (Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleEvent.DELETE);
        this.stateMachine.addTransition((Enum)HddsProtos.LifeCycleState.DELETING, (Enum)HddsProtos.LifeCycleState.DELETED, (Enum)HddsProtos.LifeCycleEvent.CLEANUP);
    }

    void loadContainer(ContainerInfo containerInfo) throws SCMException {
        this.containers.addContainer(containerInfo);
        this.containerCount.set(Long.max(containerInfo.getContainerID(), this.containerCount.get()));
    }

    ContainerInfo allocateContainer(PipelineManager pipelineManager, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor replicationFactor, String owner) throws IOException {
        Pipeline pipeline;
        try {
            pipeline = pipelineManager.createPipeline(type, replicationFactor);
        }
        catch (IOException e) {
            List<Pipeline> pipelines = pipelineManager.getPipelines(type, replicationFactor, Pipeline.PipelineState.OPEN);
            if (pipelines.isEmpty()) {
                throw new IOException("Could not allocate container. Cannot get any matching pipeline for Type:" + type + ", Factor:" + replicationFactor + ", State:PipelineState.OPEN");
            }
            pipeline = pipelines.get((int)this.containerCount.get() % pipelines.size());
        }
        return this.allocateContainer(pipelineManager, owner, pipeline);
    }

    ContainerInfo allocateContainer(PipelineManager pipelineManager, String owner, Pipeline pipeline) throws IOException {
        Preconditions.checkNotNull((Object)pipeline, (Object)"Pipeline couldn't be found for the new container. Do you have enough nodes?");
        long containerID = this.containerCount.incrementAndGet();
        ContainerInfo containerInfo = new ContainerInfo.Builder().setState(HddsProtos.LifeCycleState.OPEN).setPipelineID(pipeline.getId()).setUsedBytes(0L).setNumberOfKeys(0L).setStateEnterTime(Time.monotonicNow()).setOwner(owner).setContainerID(containerID).setDeleteTransactionId(0L).setReplicationFactor(pipeline.getFactor()).setReplicationType(pipeline.getType()).build();
        pipelineManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)containerID));
        Preconditions.checkNotNull((Object)containerInfo);
        this.containers.addContainer(containerInfo);
        LOG.trace("New container allocated: {}", (Object)containerInfo);
        return containerInfo;
    }

    ContainerInfo updateContainerState(ContainerID containerID, HddsProtos.LifeCycleEvent event) throws SCMException, ContainerNotFoundException {
        ContainerInfo info = this.containers.getContainerInfo(containerID);
        try {
            HddsProtos.LifeCycleState newState = (HddsProtos.LifeCycleState)this.stateMachine.getNextState((Enum)info.getState(), (Enum)event);
            this.containers.updateState(containerID, info.getState(), newState);
            return this.containers.getContainerInfo(containerID);
        }
        catch (InvalidStateTransitionException ex) {
            String error = String.format("Failed to update container state %s, reason: invalid state transition from state: %s upon event: %s.", containerID, info.getState(), event);
            LOG.error(error);
            throw new SCMException(error, SCMException.ResultCodes.FAILED_TO_CHANGE_CONTAINER_STATE);
        }
    }

    ContainerInfo updateContainerInfo(ContainerInfo info) throws ContainerNotFoundException {
        this.containers.updateContainerInfo(info);
        return this.containers.getContainerInfo(info.containerID());
    }

    void updateDeleteTransactionId(Map<Long, Long> deleteTransactionMap) {
        deleteTransactionMap.forEach((k, v) -> {
            try {
                this.containers.getContainerInfo(ContainerID.valueof((long)k)).updateDeleteTransactionId(v.longValue());
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Exception while updating delete transaction id.", (Throwable)e);
            }
        });
    }

    ContainerInfo getMatchingContainer(long size, String owner, PipelineID pipelineID, NavigableSet<ContainerID> containerIDs) {
        ContainerInfo selectedContainer;
        if (containerIDs.isEmpty()) {
            return null;
        }
        ContainerState key = new ContainerState(owner, pipelineID);
        ContainerID lastID = this.lastUsedMap.getOrDefault(key, (ContainerID)containerIDs.first());
        NavigableSet<ContainerID> resultSet = containerIDs.tailSet(lastID, false);
        if (resultSet.size() == 0) {
            resultSet = containerIDs;
        }
        if ((selectedContainer = this.findContainerWithSpace(size, resultSet, owner, pipelineID)) == null) {
            resultSet = containerIDs.headSet(lastID, true);
            selectedContainer = this.findContainerWithSpace(size, resultSet, owner, pipelineID);
        }
        return selectedContainer;
    }

    private ContainerInfo findContainerWithSpace(long size, NavigableSet<ContainerID> searchSet, String owner, PipelineID pipelineID) {
        try {
            for (ContainerID id : searchSet) {
                ContainerInfo containerInfo = this.containers.getContainerInfo(id);
                if (containerInfo.getUsedBytes() + size > this.containerSize) continue;
                containerInfo.updateLastUsedTime();
                return containerInfo;
            }
        }
        catch (ContainerNotFoundException e) {
            LOG.warn("Exception while finding container with space", (Throwable)e);
        }
        return null;
    }

    Set<ContainerID> getAllContainerIDs() {
        return this.containers.getAllContainerIDs();
    }

    Set<ContainerID> getContainerIDsByState(HddsProtos.LifeCycleState state) {
        return this.containers.getContainerIDsByState(state);
    }

    NavigableSet<ContainerID> getMatchingContainerIDs(String owner, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.LifeCycleState state) {
        return this.containers.getMatchingContainerIDs(state, owner, factor, type);
    }

    ContainerInfo getContainer(ContainerID containerID) throws ContainerNotFoundException {
        return this.containers.getContainerInfo(containerID);
    }

    void close() throws IOException {
    }

    Set<ContainerReplica> getContainerReplicas(ContainerID containerID) throws ContainerNotFoundException {
        return this.containers.getContainerReplicas(containerID);
    }

    void updateContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException {
        this.containers.updateContainerReplica(containerID, replica);
    }

    void removeContainerReplica(ContainerID containerID, ContainerReplica replica) throws ContainerNotFoundException, ContainerReplicaNotFoundException {
        this.containers.removeContainerReplica(containerID, replica);
    }

    void removeContainer(ContainerID containerID) throws ContainerNotFoundException {
        this.containers.removeContainer(containerID);
    }

    public synchronized void updateLastUsedMap(PipelineID pipelineID, ContainerID containerID, String owner) {
        this.lastUsedMap.put(new ContainerState(owner, pipelineID), containerID);
    }
}

