/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;

public final class ReportHandlerHelper {
    private ReportHandlerHelper() {
    }

    static void processContainerReplica(ContainerManager containerManager, ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto, DatanodeDetails datanodeDetails, EventPublisher publisher, Logger logger) throws IOException {
        ContainerReplica replica = ContainerReplica.newBuilder().setContainerID(containerId).setContainerState(replicaProto.getState()).setDatanodeDetails(datanodeDetails).setOriginNodeId(UUID.fromString(replicaProto.getOriginNodeId())).setSequenceId(replicaProto.getBlockCommitSequenceId()).build();
        containerManager.updateContainerReplica(containerId, replica);
        ReportHandlerHelper.reconcileContainerState(containerManager, containerId, publisher, logger);
        ContainerInfo containerInfo = containerManager.getContainer(containerId);
        if (containerInfo.getUsedBytes() < replicaProto.getUsed()) {
            containerInfo.setUsedBytes(replicaProto.getUsed());
        }
        if (containerInfo.getNumberOfKeys() < replicaProto.getKeyCount()) {
            containerInfo.setNumberOfKeys(replicaProto.getKeyCount());
        }
        ReportHandlerHelper.sendReplicaCommands(datanodeDetails, containerInfo, replica, publisher, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reconcileContainerState(ContainerManager manager, ContainerID containerId, EventPublisher publisher, Logger logger) throws IOException {
        ContainerInfo containerInfo = manager.getContainer(containerId);
        synchronized (containerInfo) {
            ContainerInfo container = manager.getContainer(containerId);
            Set<ContainerReplica> replicas = manager.getContainerReplicas(containerId);
            HddsProtos.LifeCycleState containerState = container.getState();
            switch (containerState) {
                case OPEN: {
                    List invalidReplicas = replicas.stream().filter(replica -> replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).collect(Collectors.toList());
                    if (invalidReplicas.isEmpty()) break;
                    logger.warn("Container {} has invalid replica state.Invalid Replicas: {}", (Object)containerId, invalidReplicas);
                    break;
                }
                case CLOSING: {
                    Optional<ContainerReplica> closedReplica = replicas.stream().filter(replica -> replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED).findFirst();
                    if (closedReplica.isPresent()) {
                        container.updateSequenceId(closedReplica.get().getSequenceId().longValue());
                        manager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.CLOSE);
                        break;
                    }
                    if (!replicas.stream().anyMatch(replica -> replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED)) break;
                    manager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.QUASI_CLOSE);
                    break;
                }
                case QUASI_CLOSED: {
                    long sequenceId;
                    if (replicas.stream().anyMatch(replica -> replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED)) {
                        manager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.FORCE_CLOSE);
                        break;
                    }
                    int replicationFactor = container.getReplicationFactor().getNumber();
                    List<ContainerReplica> quasiClosedReplicas = replicas.stream().filter(replica -> replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED).collect(Collectors.toList());
                    long uniqueQuasiClosedReplicaCount = quasiClosedReplicas.stream().map(ContainerReplica::getOriginDatanodeId).distinct().count();
                    if (uniqueQuasiClosedReplicaCount <= (long)(replicationFactor / 2) || (sequenceId = ReportHandlerHelper.forceCloseContainerReplicaWithHighestSequenceId(container, quasiClosedReplicas, publisher)) == -1L) break;
                    container.updateSequenceId(sequenceId);
                    break;
                }
                case CLOSED: {
                    break;
                }
                case DELETING: {
                    throw new UnsupportedOperationException("Unsupported container state 'DELETING'.");
                }
                case DELETED: {
                    throw new UnsupportedOperationException("Unsupported container state 'DELETED'.");
                }
            }
        }
    }

    private static long forceCloseContainerReplicaWithHighestSequenceId(ContainerInfo container, List<ContainerReplica> quasiClosedReplicas, EventPublisher publisher) {
        long highestSequenceId = quasiClosedReplicas.stream().map(ContainerReplica::getSequenceId).max(Long::compare).orElse(-1L);
        if (highestSequenceId != -1L) {
            quasiClosedReplicas.stream().filter(replica -> replica.getSequenceId() == highestSequenceId).forEach(replica -> {
                CloseContainerCommand closeContainerCommand = new CloseContainerCommand(container.getContainerID(), container.getPipelineID(), true);
                publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(replica.getDatanodeDetails().getUuid(), (SCMCommand)closeContainerCommand));
            });
        }
        return highestSequenceId;
    }

    static void sendReplicaCommands(DatanodeDetails datanodeDetails, ContainerInfo containerInfo, ContainerReplica replica, EventPublisher publisher, Logger log) {
        StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState;
        HddsProtos.LifeCycleState containerState = containerInfo.getState();
        if (!ReportHandlerHelper.compareState(containerState, replicaState = replica.getState())) {
            CloseContainerCommand closeContainerCommand;
            if (containerState == HddsProtos.LifeCycleState.OPEN) {
                log.warn("Invalid container replica state for container {} from datanode {}. Expected state is OPEN.", (Object)containerInfo.containerID(), (Object)datanodeDetails);
            }
            if (!(containerState != HddsProtos.LifeCycleState.CLOSING && containerState != HddsProtos.LifeCycleState.QUASI_CLOSED || replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN && replicaState != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING)) {
                closeContainerCommand = new CloseContainerCommand(containerInfo.getContainerID(), containerInfo.getPipelineID());
                publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(replica.getDatanodeDetails().getUuid(), (SCMCommand)closeContainerCommand));
            }
            if (containerState == HddsProtos.LifeCycleState.CLOSED && (replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN || replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING || replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED) && containerInfo.getSequenceId() == replica.getSequenceId().longValue()) {
                closeContainerCommand = new CloseContainerCommand(containerInfo.getContainerID(), containerInfo.getPipelineID(), true);
                publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(replica.getDatanodeDetails().getUuid(), (SCMCommand)closeContainerCommand));
            }
        }
    }

    private static boolean compareState(HddsProtos.LifeCycleState containerState, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State replicaState) {
        switch (containerState) {
            case OPEN: {
                return replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN;
            }
            case CLOSING: {
                return replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSING;
            }
            case QUASI_CLOSED: {
                return replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED;
            }
            case CLOSED: {
                return replicaState == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED;
            }
            case DELETING: {
                return false;
            }
            case DELETED: {
                return false;
            }
        }
        return false;
    }
}

