/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationActivityStatusMXBean;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationActivityStatus
implements ReplicationActivityStatusMXBean,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationActivityStatus.class);
    private AtomicBoolean replicationEnabled = new AtomicBoolean();
    private AtomicBoolean replicationStatusSetExternally = new AtomicBoolean();
    private ObjectName jmxObjectName;
    private ReplicationStatusListener replicationStatusListener = new ReplicationStatusListener();
    private ChillModeStatusListener chillModeStatusListener = new ChillModeStatusListener();

    @Override
    public boolean isReplicationEnabled() {
        return this.replicationEnabled.get();
    }

    @Override
    @VisibleForTesting
    public void setReplicationEnabled(boolean enabled) {
        this.replicationEnabled.set(enabled);
    }

    @VisibleForTesting
    public void enableReplication() {
        this.replicationEnabled.set(true);
    }

    public void start() {
        try {
            this.jmxObjectName = MBeans.register((String)"StorageContainerManager", (String)"ReplicationActivityStatus", (Object)this);
        }
        catch (Exception ex) {
            LOG.error("JMX bean for ReplicationActivityStatus can't be registered", (Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.jmxObjectName != null) {
            MBeans.unregister((ObjectName)this.jmxObjectName);
        }
    }

    public ReplicationStatusListener getReplicationStatusListener() {
        return this.replicationStatusListener;
    }

    public ChillModeStatusListener getChillModeStatusListener() {
        return this.chillModeStatusListener;
    }

    class ChillModeStatusListener
    implements EventHandler<Boolean> {
        ChillModeStatusListener() {
        }

        public void onMessage(Boolean inChillMode, EventPublisher publisher) {
            if (!ReplicationActivityStatus.this.replicationStatusSetExternally.get()) {
                ReplicationActivityStatus.this.replicationEnabled.set(inChillMode == false);
            }
        }
    }

    class ReplicationStatusListener
    implements EventHandler<Boolean> {
        ReplicationStatusListener() {
        }

        public void onMessage(Boolean status, EventPublisher publisher) {
            ReplicationActivityStatus.this.replicationStatusSetExternally.set(true);
            ReplicationActivityStatus.this.replicationEnabled.set(status);
        }
    }
}

