/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ReplicationRequest
implements Comparable<ReplicationRequest>,
Serializable {
    private final long containerId;
    private final int replicationCount;
    private final int expecReplicationCount;
    private final long timestamp;

    public ReplicationRequest(long containerId, int replicationCount, long timestamp, int expecReplicationCount) {
        this.containerId = containerId;
        this.replicationCount = replicationCount;
        this.timestamp = timestamp;
        this.expecReplicationCount = expecReplicationCount;
    }

    public ReplicationRequest(long containerId, int replicationCount, int expecReplicationCount) {
        this(containerId, replicationCount, System.currentTimeMillis(), expecReplicationCount);
    }

    @Override
    public int compareTo(ReplicationRequest o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        int retVal = Integer.compare(this.getReplicationCount() - this.getExpecReplicationCount(), o.getReplicationCount() - o.getExpecReplicationCount());
        if (retVal != 0) {
            return retVal;
        }
        return Long.compare(this.getTimestamp(), o.getTimestamp());
    }

    public int hashCode() {
        return new HashCodeBuilder(91, 1011).append(this.getContainerId()).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationRequest that = (ReplicationRequest)o;
        return new EqualsBuilder().append(this.getContainerId(), that.getContainerId()).isEquals();
    }

    public long getContainerId() {
        return this.containerId;
    }

    public int getReplicationCount() {
        return this.replicationCount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getExpecReplicationCount() {
        return this.expecReplicationCount;
    }

    public String toString() {
        return "ReplicationRequest{containerId=" + this.containerId + ", replicationCount=" + this.replicationCount + ", expecReplicationCount=" + this.expecReplicationCount + ", timestamp=" + this.timestamp + '}';
    }
}

