/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineUtils;

public class RatisPipelineProvider
implements PipelineProvider {
    private final NodeManager nodeManager;
    private final PipelineStateManager stateManager;
    private final Configuration conf;

    RatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, Configuration conf) {
        this.nodeManager = nodeManager;
        this.stateManager = stateManager;
        this.conf = conf;
    }

    private static ContainerPlacementPolicy createContainerPlacementPolicy(NodeManager nodeManager, Configuration conf) {
        Class implClass = conf.getClass("ozone.scm.container.placement.impl", SCMContainerPlacementRandom.class);
        try {
            Constructor ctor = implClass.getDeclaredConstructor(NodeManager.class, Configuration.class);
            return (ContainerPlacementPolicy)ctor.newInstance(nodeManager, conf);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(implClass.getName() + " could not be constructed.", e.getCause());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load ContainerPlacementPolicy", e);
        }
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor) throws IOException {
        HashSet dnsUsed = new HashSet();
        this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, factor).forEach(p -> dnsUsed.addAll(p.getNodes()));
        List dns = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).parallelStream().filter(dn -> !dnsUsed.contains(dn)).limit(factor.getNumber()).collect(Collectors.toList());
        if (dns.size() < factor.getNumber()) {
            String e = String.format("Cannot create pipeline of factor %d using %d nodes.", factor.getNumber(), dns.size());
            throw new IOException(e);
        }
        Pipeline pipeline = Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(dns).build();
        this.initializePipeline(pipeline);
        return pipeline;
    }

    @Override
    public Pipeline create(HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(nodes).build();
    }

    protected void initializePipeline(Pipeline pipeline) throws IOException {
        RatisPipelineUtils.createPipeline(pipeline, this.conf);
    }
}

