/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.chillmode.ChillModePrecheck;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.protocolPB.StorageContainerLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMClientProtocolServer
implements StorageContainerLocationProtocol,
EventHandler<Boolean>,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final RPC.Server clientRpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final StorageContainerManager scm;
    private final OzoneConfiguration conf;
    private ChillModePrecheck chillModePrecheck;

    public SCMClientProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.conf = conf;
        this.chillModePrecheck = new ChillModePrecheck((Configuration)conf);
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 10);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService storageProtoPbService = StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.newReflectiveBlockingService((StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.BlockingInterface)new StorageContainerLocationProtocolServerSideTranslatorPB((StorageContainerLocationProtocol)this));
        InetSocketAddress scmAddress = HddsServerUtil.getScmClientBindAddress((Configuration)conf);
        this.clientRpcServer = StorageContainerManager.startRpcServer(conf, scmAddress, StorageContainerLocationProtocolPB.class, storageProtoPbService, handlerCount);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)"ozone.scm.client.address", (InetSocketAddress)scmAddress, (RPC.Server)this.clientRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.clientRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
    }

    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }

    public void start() {
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Client ", this.getClientRpcAddress()));
        this.getClientRpcServer().start();
    }

    public void stop() {
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    @VisibleForTesting
    public String getRpcRemoteUsername() {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        return user == null ? null : user.getUserName();
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ScmUtils.preCheck(HddsProtos.ScmOps.allocateContainer, this.chillModePrecheck);
        this.getScm().checkAdminAccess(this.getRpcRemoteUsername());
        ContainerInfo container = this.scm.getContainerManager().allocateContainer(replicationType, factor, owner);
        Pipeline pipeline = this.scm.getPipelineManager().getPipeline(container.getPipelineID());
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        String remoteUser = this.getRpcRemoteUsername();
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        this.getScm().checkAdminAccess(remoteUser);
        try {
            ContainerInfo containerInfo = this.scm.getContainerManager().getContainer(ContainerID.valueof((long)containerID));
            return containerInfo;
        }
        catch (IOException ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER, auditMap));
            }
        }
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        boolean auditSuccess = true;
        try {
            ContainerInfo contInfo;
            if (this.chillModePrecheck.isInChillMode() && (contInfo = this.scm.getContainerManager().getContainer(ContainerID.valueof((long)containerID))).isOpen() && !this.hasRequiredReplicas(contInfo)) {
                throw new SCMException("Open container " + containerID + " doesn't have enough replicas to service this operation in Chill mode.", SCMException.ResultCodes.CHILL_MODE_EXCEPTION);
            }
            this.getScm().checkAdminAccess(null);
            ContainerID id = ContainerID.valueof((long)containerID);
            ContainerInfo container = this.scm.getContainerManager().getContainer(id);
            Pipeline pipeline = container.isOpen() ? this.scm.getPipelineManager().getPipeline(container.getPipelineID()) : this.scm.getPipelineManager().createPipeline(HddsProtos.ReplicationType.STAND_ALONE, container.getReplicationFactor(), this.scm.getContainerManager().getContainerReplicas(id).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList()));
            ContainerWithPipeline containerWithPipeline = new ContainerWithPipeline(container, pipeline);
            return containerWithPipeline;
        }
        catch (IOException ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_CONTAINER_WITH_PIPELINE, auditMap));
            }
        }
    }

    private boolean hasRequiredReplicas(ContainerInfo contInfo) {
        try {
            return this.getScm().getContainerManager().getContainerReplicas(contInfo.containerID()).size() >= contInfo.getReplicationFactor().getNumber();
        }
        catch (ContainerNotFoundException ex) {
            return false;
        }
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        try {
            ContainerID containerId = startContainerID != 0L ? ContainerID.valueof((long)startContainerID) : null;
            List<ContainerInfo> list = this.scm.getContainerManager().listContainer(containerId, count);
            return list;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.LIST_CONTAINER, auditMap));
            }
        }
    }

    public void deleteContainer(long containerID) throws IOException {
        String remoteUser = this.getRpcRemoteUsername();
        boolean auditSuccess = true;
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        auditMap.put("remoteUser", remoteUser);
        try {
            this.getScm().checkAdminAccess(remoteUser);
            this.scm.getContainerManager().deleteContainer(ContainerID.valueof((long)containerID));
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.DELETE_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.DELETE_CONTAINER, auditMap));
            }
        }
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeState state, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        if (queryScope == HddsProtos.QueryScope.POOL) {
            throw new IllegalArgumentException("Not Supported yet");
        }
        ArrayList<HddsProtos.Node> result = new ArrayList<HddsProtos.Node>();
        this.queryNode(state).forEach(node -> result.add(HddsProtos.Node.newBuilder().setNodeID(node.getProtoBufMessage()).addNodeStates(state).build()));
        return result;
    }

    public void notifyObjectStageChange(StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type type, long id, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op op, StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage stage) throws IOException {
        LOG.info("Object type {} id {} op {} new stage {}", new Object[]{type, id, op, stage});
        if (type == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Type.container && op == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Op.close) {
            if (stage == StorageContainerLocationProtocolProtos.ObjectStageChangeRequestProto.Stage.begin) {
                this.scm.getContainerManager().updateContainerState(ContainerID.valueof((long)id), HddsProtos.LifeCycleEvent.FINALIZE);
            } else {
                this.scm.getContainerManager().updateContainerState(ContainerID.valueof((long)id), HddsProtos.LifeCycleEvent.CLOSE);
            }
        }
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return null;
    }

    public List<Pipeline> listPipelines() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.LIST_PIPELINE, null));
        return this.scm.getPipelineManager().getPipelines();
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        PipelineManager pipelineManager = this.scm.getPipelineManager();
        Pipeline pipeline = pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
        pipelineManager.finalizeAndDestroyPipeline(pipeline, false);
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.CLOSE_PIPELINE, null));
    }

    public ScmInfo getScmInfo() throws IOException {
        boolean auditSuccess = true;
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId());
            ScmInfo scmInfo = builder.build();
            return scmInfo;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_SCM_INFO, null));
            }
        }
    }

    public boolean inChillMode() throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.IN_CHILL_MODE, null));
        return this.scm.isInChillMode();
    }

    public boolean forceExitChillMode() throws IOException {
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.FORCE_EXIT_CHILL_MODE, null));
        return this.scm.exitChillMode();
    }

    public List<DatanodeDetails> queryNode(HddsProtos.NodeState state) {
        Preconditions.checkNotNull((Object)state, (Object)"Node Query set cannot be null");
        return new ArrayList<DatanodeDetails>(this.queryNodeState(state));
    }

    @VisibleForTesting
    public StorageContainerManager getScm() {
        return this.scm;
    }

    public void onMessage(Boolean inChillMode, EventPublisher publisher) {
        this.chillModePrecheck.setInChillMode(inChillMode);
    }

    public boolean getChillModeStatus() {
        return this.chillModePrecheck.isInChillMode();
    }

    private Set<DatanodeDetails> queryNodeState(HddsProtos.NodeState nodeState) {
        TreeSet<DatanodeDetails> returnSet = new TreeSet<DatanodeDetails>();
        List<DatanodeDetails> tmp = this.scm.getScmNodeManager().getNodes(nodeState);
        if (tmp != null && tmp.size() > 0) {
            returnSet.addAll(tmp);
        }
        return returnSet;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName()).atIp(Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress()).forOperation(op.getAction()).withParams(auditMap).withResult(AuditEventStatus.SUCCESS.toString()).withException(null).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName()).atIp(Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress()).forOperation(op.getAction()).withParams(auditMap).withResult(AuditEventStatus.FAILURE.toString()).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }
}

