/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SCMPolicyProvider
extends PolicyProvider {
    private static AtomicReference<SCMPolicyProvider> atomicReference = new AtomicReference();
    private static final Service[] SCM_SERVICES = new Service[]{new Service("hdds.security.client.datanode.container.protocol.acl", StorageContainerDatanodeProtocol.class), new Service("hdds.security.client.scm.container.protocol.acl", StorageContainerLocationProtocol.class), new Service("hdds.security.client.scm.block.protocol.acl", ScmBlockLocationProtocol.class), new Service("hdds.security.client.scm.certificate.protocol.acl", SCMSecurityProtocol.class)};

    private SCMPolicyProvider() {
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SCMPolicyProvider getInstance() {
        if (atomicReference.get() == null) {
            atomicReference.compareAndSet(null, new SCMPolicyProvider());
        }
        return atomicReference.get();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Service[] getServices() {
        return SCM_SERVICES;
    }
}

