/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KerberosInfo(serverPrincipal="hdds.scm.kerberos.principal")
@InterfaceAudience.Private
public class SCMSecurityProtocolServer
implements SCMSecurityProtocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private final SecurityConfig config;
    private final CertificateServer certificateServer;
    private final RPC.Server rpcServer;
    private final InetSocketAddress rpcAddress;

    SCMSecurityProtocolServer(OzoneConfiguration conf, CertificateServer certificateServer) throws IOException {
        this.config = new SecurityConfig((Configuration)conf);
        this.certificateServer = certificateServer;
        int handlerCount = conf.getInt("ozone.scm.security.handler.count.key", 2);
        this.rpcAddress = HddsServerUtil.getScmSecurityInetAddress((Configuration)conf);
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService secureProtoPbService = SCMSecurityProtocolProtos.SCMSecurityProtocolService.newReflectiveBlockingService((SCMSecurityProtocolProtos.SCMSecurityProtocolService.BlockingInterface)new SCMSecurityProtocolServerSideTranslatorPB((SCMSecurityProtocol)this));
        this.rpcServer = StorageContainerManager.startRpcServer(conf, this.rpcAddress, SCMSecurityProtocolPB.class, secureProtoPbService, handlerCount);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
    }

    public String getDataNodeCertificate(HddsProtos.DatanodeDetailsProto dnDetails, String certSignReq) throws IOException {
        LOGGER.info("Processing CSR for dn {}, UUID: {}", (Object)dnDetails.getHostName(), (Object)dnDetails.getUuid());
        Objects.requireNonNull(dnDetails);
        Future future = this.certificateServer.requestCertificate(certSignReq, CertificateApprover.ApprovalType.KERBEROS_TRUSTED);
        try {
            return CertificateCodec.getPEMEncodedString((X509CertificateHolder)((X509CertificateHolder)future.get()));
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("getDataNodeCertificate operation failed. ", (Throwable)e);
            throw new IOException("getDataNodeCertificate operation failed. ", e);
        }
    }

    public String getOMCertificate(HddsProtos.OzoneManagerDetailsProto omDetails, String certSignReq) throws IOException {
        LOGGER.info("Processing CSR for om {}, UUID: {}", (Object)omDetails.getHostName(), (Object)omDetails.getUuid());
        Objects.requireNonNull(omDetails);
        Future future = this.certificateServer.requestCertificate(certSignReq, CertificateApprover.ApprovalType.KERBEROS_TRUSTED);
        try {
            return CertificateCodec.getPEMEncodedString((X509CertificateHolder)((X509CertificateHolder)future.get()));
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("getOMCertificate operation failed. ", (Throwable)e);
            throw new IOException("getOMCertificate operation failed. ", e);
        }
    }

    public String getCertificate(String certSerialId) throws IOException {
        LOGGER.debug("Getting certificate with certificate serial id", (Object)certSerialId);
        try {
            X509Certificate certificate = this.certificateServer.getCertificate(certSerialId);
            if (certificate != null) {
                return CertificateCodec.getPEMEncodedString((X509Certificate)certificate);
            }
        }
        catch (CertificateException e) {
            LOGGER.error("getCertificate operation failed. ", (Throwable)e);
            throw new IOException("getCertificate operation failed. ", e);
        }
        LOGGER.debug("Certificate with serial id {} not found.", (Object)certSerialId);
        throw new IOException("Certificate not found");
    }

    public String getCACertificate() throws IOException {
        LOGGER.debug("Getting CA certificate.");
        try {
            return CertificateCodec.getPEMEncodedString((X509CertificateHolder)this.certificateServer.getCACertificate());
        }
        catch (CertificateException e) {
            LOGGER.error("getRootCertificate operation failed. ", (Throwable)e);
            throw new IOException("getRootCertificate operation failed. ", e);
        }
    }

    public RPC.Server getRpcServer() {
        return this.rpcServer;
    }

    public InetSocketAddress getRpcAddress() {
        return this.rpcAddress;
    }

    public void start() {
        LOGGER.info(StorageContainerManager.buildRpcServerStartMessage("Starting RPC server for SCMSecurityProtocolServer.", this.getRpcAddress()));
        this.getRpcServer().start();
    }

    public void stop() {
        try {
            LOGGER.info("Stopping the SCMSecurityProtocolServer.");
            this.getRpcServer().stop();
        }
        catch (Exception ex) {
            LOGGER.error("SCMSecurityProtocolServer stop failed.", (Throwable)ex);
        }
    }

    public void join() throws InterruptedException {
        LOGGER.trace("Join RPC server for SCMSecurityProtocolServer.");
        this.getRpcServer().join();
    }
}

