/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.states.ReportResult;

public class Node2ObjectsMap<T> {
    protected final Map<UUID, Set<T>> dn2ObjectMap = new ConcurrentHashMap<UUID, Set<T>>();

    public boolean isKnownDatanode(UUID datanodeID) {
        Preconditions.checkNotNull((Object)datanodeID);
        return this.dn2ObjectMap.containsKey(datanodeID);
    }

    public void insertNewDatanode(UUID datanodeID, Set<T> containerIDs) throws SCMException {
        Preconditions.checkNotNull(containerIDs);
        Preconditions.checkNotNull((Object)datanodeID);
        if (this.dn2ObjectMap.putIfAbsent(datanodeID, new HashSet<T>(containerIDs)) != null) {
            throw new SCMException("Node already exists in the map", SCMException.ResultCodes.DUPLICATE_DATANODE);
        }
    }

    void removeDatanode(UUID datanodeID) {
        Preconditions.checkNotNull((Object)datanodeID);
        this.dn2ObjectMap.computeIfPresent(datanodeID, (k, v) -> null);
    }

    Set<T> getObjects(UUID datanode) {
        Preconditions.checkNotNull((Object)datanode);
        Set<T> s = this.dn2ObjectMap.get(datanode);
        return s != null ? Collections.unmodifiableSet(s) : Collections.emptySet();
    }

    public ReportResult.ReportResultBuilder<T> newBuilder() {
        return new ReportResult.ReportResultBuilder();
    }

    public ReportResult<T> processReport(UUID datanodeID, Set<T> objects) {
        Preconditions.checkNotNull((Object)datanodeID);
        Preconditions.checkNotNull(objects);
        if (!this.isKnownDatanode(datanodeID)) {
            return this.newBuilder().setStatus(ReportResult.ReportStatus.NEW_DATANODE_FOUND).setNewEntries(objects).build();
        }
        Set<T> currentSet = this.dn2ObjectMap.get(datanodeID);
        TreeSet<T> newObjects = new TreeSet<T>(objects);
        newObjects.removeAll(currentSet);
        TreeSet<T> missingObjects = new TreeSet<T>(currentSet);
        missingObjects.removeAll(objects);
        if (newObjects.isEmpty() && missingObjects.isEmpty()) {
            return this.newBuilder().setStatus(ReportResult.ReportStatus.ALL_IS_WELL).build();
        }
        if (newObjects.isEmpty() && !missingObjects.isEmpty()) {
            return this.newBuilder().setStatus(ReportResult.ReportStatus.MISSING_ENTRIES).setMissingEntries(missingObjects).build();
        }
        if (!newObjects.isEmpty() && missingObjects.isEmpty()) {
            return this.newBuilder().setStatus(ReportResult.ReportStatus.NEW_ENTRIES_FOUND).setNewEntries(newObjects).build();
        }
        if (!newObjects.isEmpty() && !missingObjects.isEmpty()) {
            return this.newBuilder().setStatus(ReportResult.ReportStatus.MISSING_AND_NEW_ENTRIES_FOUND).setNewEntries(newObjects).setMissingEntries(missingObjects).build();
        }
        return this.newBuilder().setStatus(ReportResult.ReportStatus.ALL_IS_WELL).build();
    }

    @VisibleForTesting
    public int size() {
        return this.dn2ObjectMap.size();
    }
}

