/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineActionHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(PipelineActionHandler.class);
    private final PipelineManager pipelineManager;
    private final Configuration ozoneConf;

    public PipelineActionHandler(PipelineManager pipelineManager, OzoneConfiguration conf) {
        this.pipelineManager = pipelineManager;
        this.ozoneConf = conf;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode report, EventPublisher publisher) {
        for (StorageContainerDatanodeProtocolProtos.PipelineAction action : ((StorageContainerDatanodeProtocolProtos.PipelineActionsProto)report.getReport()).getPipelineActionsList()) {
            if (action.getAction() == StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE) {
                PipelineID pipelineID = null;
                try {
                    pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)action.getClosePipeline().getPipelineID());
                    Pipeline pipeline = this.pipelineManager.getPipeline(pipelineID);
                    LOG.info("Received pipeline action {} for {} from datanode {}", new Object[]{action.getAction(), pipeline, report.getDatanodeDetails()});
                    this.pipelineManager.finalizeAndDestroyPipeline(pipeline, true);
                }
                catch (IOException ioe) {
                    LOG.error("Could not execute pipeline action={} pipeline={} {}", new Object[]{action, pipelineID, ioe});
                }
                continue;
            }
            LOG.error("unknown pipeline action:{}" + action.getAction());
        }
    }
}

