/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SimplePipelineProvider;
import org.apache.ratis.grpc.GrpcTlsConfig;

public final class PipelineFactory {
    private Map<HddsProtos.ReplicationType, PipelineProvider> providers = new HashMap<HddsProtos.ReplicationType, PipelineProvider>();

    PipelineFactory(NodeManager nodeManager, PipelineStateManager stateManager, Configuration conf, GrpcTlsConfig tlsConfig) {
        this.providers.put(HddsProtos.ReplicationType.STAND_ALONE, new SimplePipelineProvider(nodeManager));
        this.providers.put(HddsProtos.ReplicationType.RATIS, new RatisPipelineProvider(nodeManager, stateManager, conf, tlsConfig));
    }

    @VisibleForTesting
    void setProvider(HddsProtos.ReplicationType replicationType, PipelineProvider provider) {
        this.providers.put(replicationType, provider);
    }

    public Pipeline create(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) throws IOException {
        return this.providers.get(type).create(factor);
    }

    public Pipeline create(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return this.providers.get(type).create(factor, nodes);
    }

    public void shutdown() {
        this.providers.values().forEach(provider -> provider.shutdown());
    }
}

