/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.ratis.RatisHelper;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RatisPipelineUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RatisPipelineUtils.class);

    private RatisPipelineUtils() {
    }

    static void destroyPipeline(Pipeline pipeline, Configuration ozoneConf, GrpcTlsConfig grpcTlsConfig) {
        RaftGroup group = RatisHelper.newRaftGroup((Pipeline)pipeline);
        LOG.debug("destroying pipeline:{} with {}", (Object)pipeline.getId(), (Object)group);
        for (DatanodeDetails dn : pipeline.getNodes()) {
            try {
                RatisPipelineUtils.destroyPipeline(dn, pipeline.getId(), ozoneConf, grpcTlsConfig);
            }
            catch (IOException e) {
                LOG.warn("Pipeline destroy failed for pipeline={} dn={}", (Object)pipeline.getId(), (Object)dn);
            }
        }
    }

    static void destroyPipeline(DatanodeDetails dn, PipelineID pipelineID, Configuration ozoneConf, GrpcTlsConfig grpcTlsConfig) throws IOException {
        String rpcType = ozoneConf.get("dfs.container.ratis.rpc.type", "GRPC");
        RetryPolicy retryPolicy = RatisHelper.createRetryPolicy((Configuration)ozoneConf);
        RaftPeer p = RatisHelper.toRaftPeer((DatanodeDetails)dn);
        int maxOutstandingRequests = HddsClientUtils.getMaxOutstandingRequests((Configuration)ozoneConf);
        TimeDuration requestTimeout = RatisHelper.getClientRequestTimeout((Configuration)ozoneConf);
        try (RaftClient client = RatisHelper.newRaftClient((RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), (RaftPeer)p, (RetryPolicy)retryPolicy, (int)maxOutstandingRequests, (GrpcTlsConfig)grpcTlsConfig, (TimeDuration)requestTimeout);){
            client.groupRemove(RaftGroupId.valueOf((UUID)pipelineID.getId()), true, p.getId());
        }
    }
}

