/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyPipelineSafeModeRule
extends SafeModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    public static final Logger LOG = LoggerFactory.getLogger(HealthyPipelineSafeModeRule.class);
    private final PipelineManager pipelineManager;
    private final int healthyPipelineThresholdCount;
    private int currentHealthyPipelineCount = 0;
    private final Set<DatanodeDetails> processedDatanodeDetails = new HashSet<DatanodeDetails>();

    HealthyPipelineSafeModeRule(String ruleName, EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager manager, Configuration configuration) {
        super(manager, ruleName, eventQueue);
        this.pipelineManager = pipelineManager;
        double healthyPipelinesPercent = configuration.getDouble("hdds.scm.safemode.healthy.pipelie.pct", 0.1);
        Preconditions.checkArgument((healthyPipelinesPercent >= 0.0 && healthyPipelinesPercent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.healthy.pipelie.pct value should be >= 0.0 and <= 1.0");
        int pipelineCount = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size();
        this.healthyPipelineThresholdCount = (int)Math.ceil(healthyPipelinesPercent * (double)pipelineCount);
        LOG.info(" Total pipeline count is {}, healthy pipeline threshold count is {}", (Object)pipelineCount, (Object)this.healthyPipelineThresholdCount);
        this.getSafeModeMetrics().setNumHealthyPipelinesThreshold(this.healthyPipelineThresholdCount);
    }

    @Override
    protected TypedEvent<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> getEventType() {
        return SCMEvents.PROCESSED_PIPELINE_REPORT;
    }

    @Override
    protected boolean validate() {
        return this.currentHealthyPipelineCount >= this.healthyPipelineThresholdCount;
    }

    @Override
    protected void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        DatanodeDetails dnDetails = pipelineReportFromDatanode.getDatanodeDetails();
        if (!this.processedDatanodeDetails.contains(pipelineReportFromDatanode.getDatanodeDetails())) {
            StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
            for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
                Pipeline pipeline;
                PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
                try {
                    pipeline = this.pipelineManager.getPipeline(pipelineID);
                }
                catch (PipelineNotFoundException e) {
                    continue;
                }
                if (pipeline.getFactor() != HddsProtos.ReplicationFactor.THREE || pipeline.getPipelineState() != Pipeline.PipelineState.OPEN) continue;
                ++this.currentHealthyPipelineCount;
                this.getSafeModeMetrics().incCurrentHealthyPipelinesCount();
            }
            if (this.scmInSafeMode()) {
                SCMSafeModeManager.getLogger().info("SCM in safe mode. Healthy pipelines reported count is {}, required healthy pipeline reported count is {}", (Object)this.currentHealthyPipelineCount, (Object)this.healthyPipelineThresholdCount);
            }
            this.processedDatanodeDetails.add(dnDetails);
        }
    }

    @Override
    protected void cleanup() {
        this.processedDatanodeDetails.clear();
    }

    @VisibleForTesting
    public int getCurrentHealthyPipelineCount() {
        return this.currentHealthyPipelineCount;
    }

    @VisibleForTesting
    public int getHealthyPipelineThresholdCount() {
        return this.healthyPipelineThresholdCount;
    }
}

