/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneReplicaPipelineSafeModeRule
extends SafeModeExitRule<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(OneReplicaPipelineSafeModeRule.class);
    private int thresholdCount;
    private Set<PipelineID> reportedPipelineIDSet = new HashSet<PipelineID>();
    private final PipelineManager pipelineManager;
    private int currentReportedPipelineCount = 0;

    public OneReplicaPipelineSafeModeRule(String ruleName, EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager safeModeManager, Configuration configuration) {
        super(safeModeManager, ruleName, eventQueue);
        this.pipelineManager = pipelineManager;
        double percent = configuration.getDouble("hdds.scm.safemode.atleast.one.node.reported.pipeline.pct", 0.9);
        Preconditions.checkArgument((percent >= 0.0 && percent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.atleast.one.node.reported.pipeline.pct value should be >= 0.0 and <= 1.0");
        int totalPipelineCount = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size();
        this.thresholdCount = (int)Math.ceil(percent * (double)totalPipelineCount);
        LOG.info(" Total pipeline count is {}, pipeline's with atleast one datanode reported threshold count is {}", (Object)totalPipelineCount, (Object)this.thresholdCount);
        this.getSafeModeMetrics().setNumPipelinesWithAtleastOneReplicaReportedThreshold(this.thresholdCount);
    }

    @Override
    protected TypedEvent<SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode> getEventType() {
        return SCMEvents.PROCESSED_PIPELINE_REPORT;
    }

    @Override
    protected boolean validate() {
        return this.currentReportedPipelineCount >= this.thresholdCount;
    }

    @Override
    protected void process(SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode pipelineReportFromDatanode) {
        Preconditions.checkNotNull((Object)pipelineReportFromDatanode);
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReport = (StorageContainerDatanodeProtocolProtos.PipelineReportsProto)pipelineReportFromDatanode.getReport();
        for (StorageContainerDatanodeProtocolProtos.PipelineReport report : pipelineReport.getPipelineReportList()) {
            Pipeline pipeline;
            PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)report.getPipelineID());
            try {
                pipeline = this.pipelineManager.getPipeline(pipelineID);
            }
            catch (PipelineNotFoundException e) {
                continue;
            }
            if (pipeline.getFactor() != HddsProtos.ReplicationFactor.THREE || this.reportedPipelineIDSet.contains(pipelineID)) continue;
            this.reportedPipelineIDSet.add(pipelineID);
            this.getSafeModeMetrics().incCurrentHealthyPipelinesWithAtleastOneReplicaReportedCount();
        }
        this.currentReportedPipelineCount = this.reportedPipelineIDSet.size();
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. Pipelines with atleast one datanode reported count is {}, required atleast one datanode reported per pipeline count is {}", (Object)this.currentReportedPipelineCount, (Object)this.thresholdCount);
        }
    }

    @Override
    protected void cleanup() {
        this.reportedPipelineIDSet.clear();
    }

    @VisibleForTesting
    public int getThresholdCount() {
        return this.thresholdCount;
    }

    @VisibleForTesting
    public int getCurrentReportedPipelineCount() {
        return this.currentReportedPipelineCount;
    }
}

