/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.container.ReplicationManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeModeHandler
implements EventHandler<SCMSafeModeManager.SafeModeStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(SafeModeHandler.class);
    private final SCMClientProtocolServer scmClientProtocolServer;
    private final BlockManager scmBlockManager;
    private final long waitTime;
    private final AtomicBoolean isInSafeMode = new AtomicBoolean(true);
    private final ReplicationManager replicationManager;
    private final PipelineManager scmPipelineManager;

    public SafeModeHandler(Configuration configuration, SCMClientProtocolServer clientProtocolServer, BlockManager blockManager, ReplicationManager replicationManager, PipelineManager pipelineManager) {
        Objects.requireNonNull(configuration, "Configuration cannot be null");
        Objects.requireNonNull(clientProtocolServer, "SCMClientProtocolServer object cannot be null");
        Objects.requireNonNull(blockManager, "BlockManager object cannot be null");
        Objects.requireNonNull(replicationManager, "ReplicationManager object cannot be null");
        Objects.requireNonNull(pipelineManager, "PipelineManager object cannot benull");
        this.waitTime = configuration.getTimeDuration("hdds.scm.wait.time.after.safemode.exit", "5m", TimeUnit.MILLISECONDS);
        this.scmClientProtocolServer = clientProtocolServer;
        this.scmBlockManager = blockManager;
        this.replicationManager = replicationManager;
        this.scmPipelineManager = pipelineManager;
        boolean safeModeEnabled = configuration.getBoolean("hdds.scm.safemode.enabled", true);
        this.isInSafeMode.set(safeModeEnabled);
    }

    public void onMessage(SCMSafeModeManager.SafeModeStatus safeModeStatus, EventPublisher publisher) {
        this.isInSafeMode.set(safeModeStatus.getSafeModeStatus());
        this.scmClientProtocolServer.setSafeModeStatus(this.isInSafeMode.get());
        this.scmBlockManager.setSafeModeStatus(this.isInSafeMode.get());
        if (!this.isInSafeMode.get()) {
            Thread safeModeExitThread = new Thread(() -> {
                try {
                    Thread.sleep(this.waitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.replicationManager.start();
                this.cleanupPipelines();
            });
            safeModeExitThread.setDaemon(true);
            safeModeExitThread.start();
        }
    }

    private void cleanupPipelines() {
        List<Pipeline> pipelineList = this.scmPipelineManager.getPipelines();
        pipelineList.forEach(pipeline -> {
            try {
                if (pipeline.getPipelineState() == Pipeline.PipelineState.ALLOCATED) {
                    this.scmPipelineManager.finalizeAndDestroyPipeline((Pipeline)pipeline, false);
                }
            }
            catch (IOException ex) {
                LOG.error("Finalize and destroy pipeline failed for pipeline " + pipeline.toString(), (Throwable)ex);
            }
        });
    }

    public boolean getSafeModeStatus() {
        return this.isInSafeMode.get();
    }
}

