/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.utils.db.BatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMCertStore
implements CertificateStore {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCertStore.class);
    private final SCMMetadataStore scmMetadataStore;
    private final Lock lock;

    public SCMCertStore(SCMMetadataStore dbStore) {
        this.scmMetadataStore = dbStore;
        this.lock = new ReentrantLock();
    }

    public void storeValidCertificate(BigInteger serialID, X509Certificate certificate) throws IOException {
        block4: {
            this.lock.lock();
            try {
                if (this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS) == null && this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) == null) {
                    this.scmMetadataStore.getValidCertsTable().put((Object)serialID, (Object)certificate);
                    break block4;
                }
                throw new SCMSecurityException("Conflicting certificate ID");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeCertificate(BigInteger serialID) throws IOException {
        this.lock.lock();
        try {
            X509Certificate cert = this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS);
            if (cert == null) {
                LOG.error("trying to revoke a certificate that is not valid. Serial: {}", (Object)serialID.toString());
                throw new SCMSecurityException("Trying to revoke an invalid certificate.");
            }
            if (this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) != null) {
                LOG.error("Trying to revoke a certificate that is already revoked.");
                throw new SCMSecurityException("Trying to revoke an already revoked certificate.");
            }
            try (BatchOperation batch = this.scmMetadataStore.getStore().initBatchOperation();){
                this.scmMetadataStore.getRevokedCertsTable().putWithBatch(batch, (Object)serialID, (Object)cert);
                this.scmMetadataStore.getValidCertsTable().deleteWithBatch(batch, (Object)serialID);
                this.scmMetadataStore.getStore().commitBatchOperation(batch);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeExpiredCertificate(BigInteger serialID) throws IOException {
    }

    public X509Certificate getCertificateByID(BigInteger serialID, CertificateStore.CertType certType) throws IOException {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return (X509Certificate)this.scmMetadataStore.getValidCertsTable().get((Object)serialID);
        }
        return (X509Certificate)this.scmMetadataStore.getRevokedCertsTable().get((Object)serialID);
    }
}

