/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.SCMBlockDeletingService;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;

public class DatanodeDeletedBlockTransactions {
    private int nodeNum;
    private int maximumAllowedTXNum;
    private int currentTXNum;
    private ContainerManager containerManager;
    private final ArrayListMultimap<UUID, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> transactions = ArrayListMultimap.create();

    DatanodeDeletedBlockTransactions(ContainerManager containerManager, int maximumAllowedTXNum, int nodeNum) {
        this.containerManager = containerManager;
        this.maximumAllowedTXNum = maximumAllowedTXNum;
        this.nodeNum = nodeNum;
    }

    public boolean addTransaction(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx, Set<UUID> dnsWithTransactionCommitted) {
        try {
            boolean success = false;
            ContainerID id = ContainerID.valueof((long)tx.getContainerID());
            ContainerInfo container = this.containerManager.getContainer(id);
            Set<ContainerReplica> replicas = this.containerManager.getContainerReplicas(id);
            if (!container.isOpen()) {
                for (ContainerReplica replica : replicas) {
                    UUID dnID = replica.getDatanodeDetails().getUuid();
                    if (dnsWithTransactionCommitted != null && dnsWithTransactionCommitted.contains(dnID)) continue;
                    success = this.addTransactionToDN(dnID, tx);
                }
            }
            return success;
        }
        catch (IOException e) {
            SCMBlockDeletingService.LOG.warn("Got container info error.", (Throwable)e);
            return false;
        }
    }

    private boolean addTransactionToDN(UUID dnID, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction tx) {
        if (this.transactions.containsKey((Object)dnID)) {
            List txs = this.transactions.get((Object)dnID);
            if (txs != null && txs.size() < this.maximumAllowedTXNum) {
                boolean hasContained = false;
                for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction t : txs) {
                    if (t.getContainerID() != tx.getContainerID()) continue;
                    hasContained = true;
                    break;
                }
                if (!hasContained) {
                    txs.add(tx);
                    ++this.currentTXNum;
                    return true;
                }
            }
        } else {
            ++this.currentTXNum;
            this.transactions.put((Object)dnID, (Object)tx);
            return true;
        }
        SCMBlockDeletingService.LOG.debug("Transaction added: {} <- TX({})", (Object)dnID, (Object)tx.getTxID());
        return false;
    }

    Set<UUID> getDatanodeIDs() {
        return this.transactions.keySet();
    }

    boolean isEmpty() {
        return this.transactions.isEmpty();
    }

    boolean hasTransactions(UUID dnId) {
        return this.transactions.containsKey((Object)dnId) && !this.transactions.get((Object)dnId).isEmpty();
    }

    List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDatanodeTransactions(UUID dnId) {
        return this.transactions.get((Object)dnId);
    }

    List<String> getTransactionIDList(UUID dnId) {
        if (this.hasTransactions(dnId)) {
            return this.transactions.get((Object)dnId).stream().map(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getTxID).map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    boolean isFull() {
        return this.currentTXNum >= this.maximumAllowedTXNum * this.nodeNum;
    }

    int getTXNum() {
        return this.currentTXNum;
    }
}

