/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.slf4j.Logger;

public class AbstractContainerReportHandler {
    private final ContainerManager containerManager;
    private final Logger logger;

    AbstractContainerReportHandler(ContainerManager containerManager, Logger logger) {
        Preconditions.checkNotNull((Object)containerManager);
        Preconditions.checkNotNull((Object)logger);
        this.containerManager = containerManager;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContainerReplica(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) throws IOException {
        ContainerID containerId = ContainerID.valueof((long)replicaProto.getContainerID());
        ContainerReplica replica = ContainerReplica.newBuilder().setContainerID(containerId).setContainerState(replicaProto.getState()).setDatanodeDetails(datanodeDetails).setOriginNodeId(UUID.fromString(replicaProto.getOriginNodeId())).setSequenceId(replicaProto.getBlockCommitSequenceId()).build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing replica of container {} from datanode {}", (Object)containerId, (Object)datanodeDetails);
        }
        ContainerInfo containerInfo = this.containerManager.getContainer(containerId);
        synchronized (containerInfo) {
            this.updateContainerStats(containerId, replicaProto);
            this.updateContainerState(datanodeDetails, containerId, replica);
            this.containerManager.updateContainerReplica(containerId, replica);
        }
    }

    private void updateContainerStats(ContainerID containerId, StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto) throws ContainerNotFoundException {
        if (!this.isUnhealthy(() -> ((StorageContainerDatanodeProtocolProtos.ContainerReplicaProto)replicaProto).getState())) {
            ContainerInfo containerInfo = this.containerManager.getContainer(containerId);
            if (containerInfo.getSequenceId() < replicaProto.getBlockCommitSequenceId()) {
                containerInfo.updateSequenceId(replicaProto.getBlockCommitSequenceId());
            }
            if (containerInfo.getUsedBytes() < replicaProto.getUsed()) {
                containerInfo.setUsedBytes(replicaProto.getUsed());
            }
            if (containerInfo.getNumberOfKeys() < replicaProto.getKeyCount()) {
                containerInfo.setNumberOfKeys(replicaProto.getKeyCount());
            }
        }
    }

    private void updateContainerState(DatanodeDetails datanode, ContainerID containerId, ContainerReplica replica) throws IOException {
        ContainerInfo container = this.containerManager.getContainer(containerId);
        switch (container.getState()) {
            case OPEN: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN) break;
                this.logger.warn("Container {} is in OPEN state, but the datanode {} reports an {} replica.", new Object[]{containerId, datanode, replica.getState()});
                break;
            }
            case CLOSING: {
                if (replica.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED) {
                    this.logger.info("Moving container {} to QUASI_CLOSED state, datanode {} reported QUASI_CLOSED replica.", (Object)containerId, (Object)datanode);
                    this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.QUASI_CLOSE);
                }
                if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) break;
                this.logger.info("Moving container {} to CLOSED state, datanode {} reported CLOSED replica.", (Object)containerId, (Object)datanode);
                Preconditions.checkArgument((replica.getSequenceId().longValue() == container.getSequenceId() ? 1 : 0) != 0);
                this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.CLOSE);
                break;
            }
            case QUASI_CLOSED: {
                if (replica.getState() != StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED) break;
                this.logger.info("Moving container {} to CLOSED state, datanode {} reported CLOSED replica.", (Object)containerId, (Object)datanode);
                Preconditions.checkArgument((replica.getSequenceId().longValue() == container.getSequenceId() ? 1 : 0) != 0);
                this.containerManager.updateContainerState(containerId, HddsProtos.LifeCycleEvent.FORCE_CLOSE);
                break;
            }
            case CLOSED: {
                break;
            }
            case DELETING: {
                throw new UnsupportedOperationException("Unsupported container state 'DELETING'.");
            }
            case DELETED: {
                throw new UnsupportedOperationException("Unsupported container state 'DELETED'.");
            }
        }
    }

    private boolean isUnhealthy(Supplier<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State> replicaState) {
        return replicaState.get() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY;
    }

    protected ContainerManager getContainerManager() {
        return this.containerManager;
    }
}

