/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.block.PendingDeleteStatusList;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaNotFoundException;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReportHandler.class);
    private final NodeManager nodeManager;
    private final ContainerManager containerManager;

    public ContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        super(containerManager, LOG);
        this.nodeManager = nodeManager;
        this.containerManager = containerManager;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode reportFromDatanode, EventPublisher publisher) {
        DatanodeDetails datanodeDetails = reportFromDatanode.getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = (StorageContainerDatanodeProtocolProtos.ContainerReportsProto)reportFromDatanode.getReport();
        try {
            List replicas = containerReport.getReportsList();
            Set<ContainerID> containersInSCM = this.nodeManager.getContainers(datanodeDetails);
            Set<ContainerID> containersInDn = replicas.parallelStream().map(StorageContainerDatanodeProtocolProtos.ContainerReplicaProto::getContainerID).map(ContainerID::valueof).collect(Collectors.toSet());
            HashSet<ContainerID> missingReplicas = new HashSet<ContainerID>(containersInSCM);
            missingReplicas.removeAll(containersInDn);
            this.processContainerReplicas(datanodeDetails, replicas);
            this.processMissingReplicas(datanodeDetails, missingReplicas);
            this.updateDeleteTransaction(datanodeDetails, replicas, publisher);
            this.nodeManager.setContainers(datanodeDetails, containersInDn);
            this.containerManager.notifyContainerReportProcessing(true, true);
        }
        catch (NodeNotFoundException ex) {
            this.containerManager.notifyContainerReportProcessing(true, false);
            LOG.error("Received container report from unknown datanode {} {}", (Object)datanodeDetails, (Object)ex);
        }
    }

    private void processContainerReplicas(DatanodeDetails datanodeDetails, List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> replicas) {
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : replicas) {
            try {
                this.processContainerReplica(datanodeDetails, replicaProto);
            }
            catch (ContainerNotFoundException e) {
                LOG.error("Received container report for an unknown container {} from datanode {}.", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
            }
            catch (IOException e) {
                LOG.error("Exception while processing container report for container {} from datanode {}.", new Object[]{replicaProto.getContainerID(), datanodeDetails, e});
            }
        }
    }

    private void processMissingReplicas(DatanodeDetails datanodeDetails, Set<ContainerID> missingReplicas) {
        for (ContainerID id : missingReplicas) {
            try {
                this.containerManager.getContainerReplicas(id).stream().filter(replica -> replica.getDatanodeDetails().equals((Object)datanodeDetails)).findFirst().ifPresent(replica -> {
                    try {
                        this.containerManager.removeContainerReplica(id, (ContainerReplica)replica);
                    }
                    catch (ContainerNotFoundException | ContainerReplicaNotFoundException throwable) {
                        // empty catch block
                    }
                });
            }
            catch (ContainerNotFoundException e) {
                LOG.warn("Cannot remove container replica, container {} not found.", (Object)id, (Object)e);
            }
        }
    }

    private void updateDeleteTransaction(DatanodeDetails datanodeDetails, List<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> replicas, EventPublisher publisher) {
        PendingDeleteStatusList pendingDeleteStatusList = new PendingDeleteStatusList(datanodeDetails);
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replica : replicas) {
            try {
                ContainerInfo containerInfo = this.containerManager.getContainer(ContainerID.valueof((long)replica.getContainerID()));
                if (containerInfo.getDeleteTransactionId() <= replica.getDeleteTransactionId()) continue;
                pendingDeleteStatusList.addPendingDeleteStatus(replica.getDeleteTransactionId(), containerInfo.getDeleteTransactionId(), containerInfo.getContainerID());
            }
            catch (ContainerNotFoundException cnfe) {
                LOG.warn("Cannot update pending delete transaction for container #{}. Reason: container missing.", (Object)replica.getContainerID());
            }
        }
        if (pendingDeleteStatusList.getNumPendingDeletes() > 0) {
            publisher.fireEvent(SCMEvents.PENDING_DELETE_STATUS, (Object)pendingDeleteStatusList);
        }
    }
}

