/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.AbstractContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalContainerReportHandler
extends AbstractContainerReportHandler
implements EventHandler<SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalContainerReportHandler.class);
    private final NodeManager nodeManager;

    public IncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager) {
        super(containerManager, LOG);
        this.nodeManager = nodeManager;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing incremental container report from data node {}", (Object)report.getDatanodeDetails().getUuid());
        }
        boolean success = true;
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList()) {
            try {
                DatanodeDetails dd = report.getDatanodeDetails();
                ContainerID id = ContainerID.valueof((long)replicaProto.getContainerID());
                this.nodeManager.addContainer(dd, id);
                this.processContainerReplica(dd, replicaProto);
            }
            catch (ContainerNotFoundException e) {
                success = false;
                LOG.warn("Container {} not found!", (Object)replicaProto.getContainerID());
            }
            catch (NodeNotFoundException ex) {
                success = false;
                LOG.error("Received ICR from unknown datanode {} {}", (Object)report.getDatanodeDetails(), (Object)ex);
            }
            catch (IOException e) {
                success = false;
                LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID());
            }
        }
        if (success) {
            this.getContainerManager().notifyContainerReportProcessing(false, true);
        } else {
            this.getContainerManager().notifyContainerReportProcessing(false, false);
        }
    }

    protected NodeManager getNodeManager() {
        return this.nodeManager;
    }
}

