/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementCapacity
extends SCMCommonPlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementCapacity.class);

    public SCMContainerPlacementCapacity(NodeManager nodeManager, Configuration conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
    }

    @Override
    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long sizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = super.chooseDatanodes(excludedNodes, favoredNodes, nodesRequired, sizeRequired);
        if (healthyNodes.size() == nodesRequired) {
            return healthyNodes;
        }
        return this.getResultSet(nodesRequired, healthyNodes);
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        DatanodeDetails datanodeDetails;
        int secondNodeNdx;
        int firstNodeNdx = this.getRand().nextInt(healthyNodes.size());
        if (firstNodeNdx == (secondNodeNdx = this.getRand().nextInt(healthyNodes.size()))) {
            datanodeDetails = healthyNodes.get(firstNodeNdx);
        } else {
            SCMNodeMetric secondNodeMetric;
            DatanodeDetails firstNodeDetails = healthyNodes.get(firstNodeNdx);
            DatanodeDetails secondNodeDetails = healthyNodes.get(secondNodeNdx);
            SCMNodeMetric firstNodeMetric = this.getNodeManager().getNodeStat(firstNodeDetails);
            datanodeDetails = firstNodeMetric.isGreater((secondNodeMetric = this.getNodeManager().getNodeStat(secondNodeDetails)).get()) ? firstNodeDetails : secondNodeDetails;
        }
        healthyNodes.remove(datanodeDetails);
        return datanodeDetails;
    }
}

