/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementRackAware
extends SCMCommonPlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementRackAware.class);
    private final NetworkTopology networkTopology;
    private boolean fallback;
    private static final int RACK_LEVEL = 1;
    private static final int MAX_RETRY = 3;
    private final SCMContainerPlacementMetrics metrics;

    public SCMContainerPlacementRackAware(NodeManager nodeManager, Configuration conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
        this.networkTopology = networkTopology;
        this.fallback = fallback;
        this.metrics = metrics;
    }

    @Override
    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long sizeRequired) throws SCMException {
        Node secondNode;
        Node favoredNode;
        int excludedNodesCount;
        Preconditions.checkArgument((nodesRequired > 0 ? 1 : 0) != 0);
        this.metrics.incrDatanodeRequestCount(nodesRequired);
        int datanodeCount = this.networkTopology.getNumOfLeafNode("");
        int n = excludedNodesCount = excludedNodes == null ? 0 : excludedNodes.size();
        if (datanodeCount < nodesRequired + excludedNodesCount) {
            throw new SCMException("No enough datanodes to choose. TotalNode = " + datanodeCount + "RequiredNode = " + nodesRequired + "ExcludedNode = " + excludedNodesCount, null);
        }
        List<DatanodeDetails> mutableFavoredNodes = favoredNodes;
        if (mutableFavoredNodes != null && excludedNodes != null) {
            mutableFavoredNodes = new ArrayList<DatanodeDetails>();
            mutableFavoredNodes.addAll(favoredNodes);
            mutableFavoredNodes.removeAll(excludedNodes);
        }
        int favoredNodeNum = mutableFavoredNodes == null ? 0 : mutableFavoredNodes.size();
        ArrayList<Node> chosenNodes = new ArrayList<Node>();
        int favorIndex = 0;
        if (excludedNodes == null || excludedNodes.isEmpty()) {
            Node secondNode2;
            Node firstNode;
            Node favoredNode2;
            Node node = favoredNode2 = favoredNodeNum > favorIndex ? (Node)mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode2 != null) {
                firstNode = favoredNode2;
                ++favorIndex;
            } else {
                firstNode = this.chooseNode(null, null, sizeRequired);
            }
            chosenNodes.add(firstNode);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            Node node2 = favoredNode2 = favoredNodeNum > favorIndex ? (Node)mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode2 != null && this.networkTopology.isSameParent(firstNode, favoredNode2)) {
                secondNode2 = favoredNode2;
                ++favorIndex;
            } else {
                secondNode2 = this.chooseNode(chosenNodes, firstNode, sizeRequired);
            }
            chosenNodes.add(secondNode2);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            return this.chooseNodes(null, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, sizeRequired);
        }
        ArrayList<Node> mutableExcludedNodes = new ArrayList<Node>();
        mutableExcludedNodes.addAll(excludedNodes);
        if (excludedNodes.size() == 1) {
            Node firstNode;
            Node favoredNode3;
            Node node = favoredNode3 = favoredNodeNum > favorIndex ? (Node)mutableFavoredNodes.get(favorIndex) : null;
            if (favoredNode3 != null && this.networkTopology.isSameParent((Node)excludedNodes.get(0), favoredNode3)) {
                firstNode = favoredNode3;
                ++favorIndex;
            } else {
                firstNode = this.chooseNode(mutableExcludedNodes, (Node)excludedNodes.get(0), sizeRequired);
            }
            chosenNodes.add(firstNode);
            if (--nodesRequired == 0) {
                return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
            }
            return this.chooseNodes(null, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, sizeRequired);
        }
        for (int i = 0; i < excludedNodesCount; ++i) {
            for (int j = i + 1; j < excludedNodesCount; ++j) {
                if (!this.networkTopology.isSameParent((Node)excludedNodes.get(i), (Node)excludedNodes.get(j))) continue;
                return this.chooseNodes(mutableExcludedNodes, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, sizeRequired);
            }
        }
        Node node = favoredNode = favoredNodeNum > favorIndex ? (Node)mutableFavoredNodes.get(favorIndex) : null;
        if (favoredNode != null && this.networkTopology.isSameParent((Node)mutableExcludedNodes.get(0), favoredNode)) {
            secondNode = favoredNode;
            ++favorIndex;
        } else {
            secondNode = this.chooseNode(chosenNodes, (Node)mutableExcludedNodes.get(0), sizeRequired);
        }
        chosenNodes.add(secondNode);
        mutableExcludedNodes.add(secondNode);
        if (--nodesRequired == 0) {
            return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
        }
        return this.chooseNodes(mutableExcludedNodes, chosenNodes, mutableFavoredNodes, favorIndex, nodesRequired, sizeRequired);
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        return null;
    }

    private Node chooseNode(List<Node> excludedNodes, Node affinityNode, long sizeRequired) throws SCMException {
        int ancestorGen = 1;
        int maxRetry = 3;
        ArrayList<String> excludedNodesForCapacity = null;
        boolean isFallbacked = false;
        while (true) {
            this.metrics.incrDatanodeChooseAttemptCount();
            Node node = this.networkTopology.chooseRandom("", excludedNodesForCapacity, excludedNodes, affinityNode, ancestorGen);
            if (node == null) {
                LOG.warn("Failed to find the datanode for container. excludedNodes:" + (excludedNodes == null ? "" : excludedNodes.toString()) + ", affinityNode:" + (affinityNode == null ? "" : affinityNode.getNetworkFullPath()));
                if (this.fallback) {
                    isFallbacked = true;
                    if (affinityNode != null) {
                        affinityNode = null;
                        continue;
                    }
                    if (ancestorGen == 1) {
                        --ancestorGen;
                        continue;
                    }
                }
                throw new SCMException("No satisfied datanode to meet the excludedNodes and affinityNode constrains.", null);
            }
            if (super.hasEnoughSpace((DatanodeDetails)node, sizeRequired)) {
                LOG.debug("Datanode {} is chosen. Required size is {}", (Object)node.toString(), (Object)sizeRequired);
                this.metrics.incrDatanodeChooseSuccessCount();
                if (isFallbacked) {
                    this.metrics.incrDatanodeChooseFallbackCount();
                }
                return node;
            }
            if (--maxRetry == 0) {
                String errMsg = "No satisfied datanode to meet the space constrains.  sizeRequired: " + sizeRequired;
                LOG.info(errMsg);
                throw new SCMException(errMsg, null);
            }
            if (excludedNodesForCapacity == null) {
                excludedNodesForCapacity = new ArrayList<String>();
            }
            excludedNodesForCapacity.add(node.getNetworkFullPath());
        }
    }

    private List<DatanodeDetails> chooseNodes(List<Node> excludedNodes, List<Node> chosenNodes, List<DatanodeDetails> favoredNodes, int favorIndex, int nodesRequired, long sizeRequired) throws SCMException {
        Preconditions.checkArgument((chosenNodes != null ? 1 : 0) != 0);
        List<Node> excludedNodeList = excludedNodes != null ? excludedNodes : chosenNodes;
        int favoredNodeNum = favoredNodes == null ? 0 : favoredNodes.size();
        do {
            Node chosenNode;
            Node favoredNode;
            Node node = favoredNode = favoredNodeNum > favorIndex ? (Node)favoredNodes.get(favorIndex) : null;
            if (favoredNode != null && this.networkTopology.isSameParent(excludedNodeList.get(excludedNodeList.size() - 1), favoredNode)) {
                chosenNode = favoredNode;
                ++favorIndex;
            } else {
                chosenNode = this.chooseNode(excludedNodeList, null, sizeRequired);
            }
            excludedNodeList.add(chosenNode);
            if (excludedNodeList == chosenNodes) continue;
            chosenNodes.add(chosenNode);
        } while (--nodesRequired != 0);
        return Arrays.asList(chosenNodes.toArray(new DatanodeDetails[0]));
    }
}

