/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMContainerPlacementRandom
extends SCMCommonPlacementPolicy
implements PlacementPolicy {
    @VisibleForTesting
    static final Logger LOG = LoggerFactory.getLogger(SCMContainerPlacementRandom.class);

    public SCMContainerPlacementRandom(NodeManager nodeManager, Configuration conf, NetworkTopology networkTopology, boolean fallback, SCMContainerPlacementMetrics metrics) {
        super(nodeManager, conf);
    }

    @Override
    public List<DatanodeDetails> chooseDatanodes(List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes, int nodesRequired, long sizeRequired) throws SCMException {
        List<DatanodeDetails> healthyNodes = super.chooseDatanodes(excludedNodes, favoredNodes, nodesRequired, sizeRequired);
        if (healthyNodes.size() == nodesRequired) {
            return healthyNodes;
        }
        return this.getResultSet(nodesRequired, healthyNodes);
    }

    @Override
    public DatanodeDetails chooseNode(List<DatanodeDetails> healthyNodes) {
        DatanodeDetails selectedNode = healthyNodes.get(this.getRand().nextInt(healthyNodes.size()));
        healthyNodes.remove(selectedNode);
        return selectedNode;
    }
}

