/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.metadata.BigIntegerCodec;
import org.apache.hadoop.hdds.scm.metadata.DeletedBlocksTransactionCodec;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.X509CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMMetadataStoreRDBImpl
implements SCMMetadataStore {
    private static final String DELETED_BLOCKS_TABLE = "deletedBlocks";
    private Table deletedBlocksTable;
    private static final String VALID_CERTS_TABLE = "validCerts";
    private Table validCertsTable;
    private static final String REVOKED_CERTS_TABLE = "revokedCerts";
    private Table revokedCertsTable;
    private static final Logger LOG = LoggerFactory.getLogger(SCMMetadataStoreRDBImpl.class);
    private DBStore store;
    private final OzoneConfiguration configuration;
    private final AtomicLong txID;

    public SCMMetadataStoreRDBImpl(OzoneConfiguration config) throws IOException {
        this.configuration = config;
        this.start(this.configuration);
        this.txID = new AtomicLong(this.getLargestRecordedTXID());
    }

    @Override
    public void start(OzoneConfiguration config) throws IOException {
        if (this.store == null) {
            File metaDir = ServerUtils.getScmDbDir((Configuration)this.configuration);
            this.store = DBStoreBuilder.newBuilder((OzoneConfiguration)this.configuration).setName("scm.db").setPath(Paths.get(metaDir.getPath(), new String[0])).addTable(DELETED_BLOCKS_TABLE).addTable(VALID_CERTS_TABLE).addTable(REVOKED_CERTS_TABLE).addCodec(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.class, (Codec)new DeletedBlocksTransactionCodec()).addCodec(BigInteger.class, (Codec)new BigIntegerCodec()).addCodec(X509Certificate.class, (Codec)new X509CertificateCodec()).build();
            this.deletedBlocksTable = this.store.getTable(DELETED_BLOCKS_TABLE, Long.class, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.class);
            this.checkTableStatus(this.deletedBlocksTable, DELETED_BLOCKS_TABLE);
            this.validCertsTable = this.store.getTable(VALID_CERTS_TABLE, BigInteger.class, X509Certificate.class);
            this.checkTableStatus(this.validCertsTable, VALID_CERTS_TABLE);
            this.revokedCertsTable = this.store.getTable(REVOKED_CERTS_TABLE, BigInteger.class, X509Certificate.class);
            this.checkTableStatus(this.revokedCertsTable, REVOKED_CERTS_TABLE);
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeletedBlocksTXTable() {
        return this.deletedBlocksTable;
    }

    @Override
    public Long getNextDeleteBlockTXID() {
        return this.txID.incrementAndGet();
    }

    @Override
    public Table<BigInteger, X509Certificate> getValidCertsTable() {
        return this.validCertsTable;
    }

    @Override
    public Table<BigInteger, X509Certificate> getRevokedCertsTable() {
        return this.revokedCertsTable;
    }

    @Override
    public TableIterator getAllCerts(CertificateStore.CertType certType) {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return this.validCertsTable.iterator();
        }
        if (certType == CertificateStore.CertType.REVOKED_CERTS) {
            return this.revokedCertsTable.iterator();
        }
        return null;
    }

    @Override
    public Long getCurrentTXID() {
        return this.txID.get();
    }

    private Long getLargestRecordedTXID() throws IOException {
        try (TableIterator txIter = this.deletedBlocksTable.iterator();){
            txIter.seekToLast();
            Long txid = (Long)txIter.key();
            if (txid != null) {
                Long l = txid;
                return l;
            }
        }
        return 0L;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logs for more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }
}

