/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManagerMXBean;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="SCM NodeManager Metrics", context="ozone")
public final class SCMNodeMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = SCMNodeMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numHBProcessed;
    @Metric
    private MutableCounterLong numHBProcessingFailed;
    @Metric
    private MutableCounterLong numNodeReportProcessed;
    @Metric
    private MutableCounterLong numNodeReportProcessingFailed;
    private final MetricsRegistry registry;
    private final NodeManagerMXBean managerMXBean;
    private final MetricsInfo recordInfo = Interns.info((String)"SCMNodeManager", (String)"SCM NodeManager metrics");

    private SCMNodeMetrics(NodeManagerMXBean managerMXBean) {
        this.managerMXBean = managerMXBean;
        this.registry = new MetricsRegistry(this.recordInfo);
    }

    public static SCMNodeMetrics create(NodeManagerMXBean managerMXBean) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMNodeMetrics)ms.register(SOURCE_NAME, "SCM NodeManager Metrics", (Object)new SCMNodeMetrics(managerMXBean));
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    void incNumHBProcessed() {
        this.numHBProcessed.incr();
    }

    void incNumHBProcessingFailed() {
        this.numHBProcessingFailed.incr();
    }

    void incNumNodeReportProcessed() {
        this.numNodeReportProcessed.incr();
    }

    void incNumNodeReportProcessingFailed() {
        this.numNodeReportProcessingFailed.incr();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        Map<String, Integer> nodeCount = this.managerMXBean.getNodeCount();
        Map<String, Long> nodeInfo = this.managerMXBean.getNodeInfo();
        this.registry.snapshot(collector.addRecord(this.registry.info()).addGauge(Interns.info((String)"HealthyNodes", (String)"Number of healthy datanodes"), nodeCount.get(HddsProtos.NodeState.HEALTHY.toString()).intValue()).addGauge(Interns.info((String)"StaleNodes", (String)"Number of stale datanodes"), nodeCount.get(HddsProtos.NodeState.STALE.toString()).intValue()).addGauge(Interns.info((String)"DeadNodes", (String)"Number of dead datanodes"), nodeCount.get(HddsProtos.NodeState.DEAD.toString()).intValue()).addGauge(Interns.info((String)"DecommissioningNodes", (String)"Number of decommissioning datanodes"), nodeCount.get(HddsProtos.NodeState.DECOMMISSIONING.toString()).intValue()).addGauge(Interns.info((String)"DecommissionedNodes", (String)"Number of decommissioned datanodes"), nodeCount.get(HddsProtos.NodeState.DECOMMISSIONED.toString()).intValue()).addGauge(Interns.info((String)"DiskCapacity", (String)"Total disk capacity"), nodeInfo.get("DISKCapacity").longValue()).addGauge(Interns.info((String)"DiskUsed", (String)"Total disk capacity used"), nodeInfo.get("DISKUsed").longValue()).addGauge(Interns.info((String)"DiskRemaining", (String)"Total disk capacity remaining"), nodeInfo.get("DISKRemaining").longValue()).addGauge(Interns.info((String)"SSDCapacity", (String)"Total ssd capacity"), nodeInfo.get("SSDCapacity").longValue()).addGauge(Interns.info((String)"SSDUsed", (String)"Total ssd capacity used"), nodeInfo.get("SSDUsed").longValue()).addGauge(Interns.info((String)"SSDRemaining", (String)"Total disk capacity remaining"), nodeInfo.get("SSDRemaining").longValue()), all);
    }
}

