/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SimplePipelineProvider;
import org.apache.hadoop.hdds.server.events.EventPublisher;

public class PipelineFactory {
    private Map<HddsProtos.ReplicationType, PipelineProvider> providers;

    PipelineFactory(NodeManager nodeManager, PipelineStateManager stateManager, Configuration conf, EventPublisher eventPublisher) {
        this.providers = new HashMap<HddsProtos.ReplicationType, PipelineProvider>();
        this.providers.put(HddsProtos.ReplicationType.STAND_ALONE, new SimplePipelineProvider(nodeManager));
        this.providers.put(HddsProtos.ReplicationType.RATIS, new RatisPipelineProvider(nodeManager, stateManager, conf, eventPublisher));
    }

    protected PipelineFactory() {
    }

    @VisibleForTesting
    void setProvider(HddsProtos.ReplicationType replicationType, PipelineProvider provider) {
        this.providers.put(replicationType, provider);
    }

    public Pipeline create(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor) throws IOException {
        return this.providers.get(type).create(factor);
    }

    public Pipeline create(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return this.providers.get(type).create(factor, nodes);
    }

    public void close(HddsProtos.ReplicationType type, Pipeline pipeline) throws IOException {
        this.providers.get(type).close(pipeline);
    }

    public void shutdown() {
        this.providers.values().forEach(provider -> provider.shutdown());
    }

    @VisibleForTesting
    public Map<HddsProtos.ReplicationType, PipelineProvider> getProviders() {
        return this.providers;
    }

    protected void setProviders(Map<HddsProtos.ReplicationType, PipelineProvider> providers) {
        this.providers = providers;
    }
}

