/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ScmBlockLocationProtocolServerSideTranslatorPB
implements ScmBlockLocationProtocolPB {
    private final ScmBlockLocationProtocol impl;
    private static final Logger LOG = LoggerFactory.getLogger(ScmBlockLocationProtocolServerSideTranslatorPB.class);
    private final OzoneProtocolMessageDispatcher<ScmBlockLocationProtocolProtos.SCMBlockLocationRequest, ScmBlockLocationProtocolProtos.SCMBlockLocationResponse> dispatcher;

    public ScmBlockLocationProtocolServerSideTranslatorPB(ScmBlockLocationProtocol impl, ProtocolMessageMetrics metrics) throws IOException {
        this.impl = impl;
        this.dispatcher = new OzoneProtocolMessageDispatcher("BlockLocationProtocol", metrics, LOG);
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.Builder createSCMBlockResponse(ScmBlockLocationProtocolProtos.Type cmdType, String traceID) {
        return ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.newBuilder().setCmdType(cmdType).setTraceID(traceID);
    }

    public ScmBlockLocationProtocolProtos.SCMBlockLocationResponse send(RpcController controller, ScmBlockLocationProtocolProtos.SCMBlockLocationRequest request) throws ServiceException {
        return (ScmBlockLocationProtocolProtos.SCMBlockLocationResponse)this.dispatcher.processRequest((Object)request, this::processMessage, (ProtocolMessageEnum)request.getCmdType(), request.getTraceID());
    }

    private ScmBlockLocationProtocolProtos.SCMBlockLocationResponse processMessage(ScmBlockLocationProtocolProtos.SCMBlockLocationRequest request) throws ServiceException {
        ScmBlockLocationProtocolProtos.SCMBlockLocationResponse.Builder response;
        block8: {
            response = this.createSCMBlockResponse(request.getCmdType(), request.getTraceID());
            response.setSuccess(true);
            response.setStatus(ScmBlockLocationProtocolProtos.Status.OK);
            try {
                switch (request.getCmdType()) {
                    case AllocateScmBlock: {
                        response.setAllocateScmBlockResponse(this.allocateScmBlock(request.getAllocateScmBlockRequest()));
                        break;
                    }
                    case DeleteScmKeyBlocks: {
                        response.setDeleteScmKeyBlocksResponse(this.deleteScmKeyBlocks(request.getDeleteScmKeyBlocksRequest()));
                        break;
                    }
                    case GetScmInfo: {
                        response.setGetScmInfoResponse(this.getScmInfo(request.getGetScmInfoRequest()));
                        break;
                    }
                    case SortDatanodes: {
                        response.setSortDatanodesResponse(this.sortDatanodes(request.getSortDatanodesRequest()));
                        break;
                    }
                    default: {
                        throw new IOException("Unknown Operation " + request.getCmdType() + " in ScmBlockLocationProtocol");
                    }
                }
            }
            catch (IOException e) {
                response.setSuccess(false);
                response.setStatus(this.exceptionToResponseStatus(e));
                if (e.getMessage() == null) break block8;
                response.setMessage(e.getMessage());
            }
        }
        return response.build();
    }

    private ScmBlockLocationProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof SCMException) {
            return ScmBlockLocationProtocolProtos.Status.values()[((SCMException)((Object)ex)).getResult().ordinal()];
        }
        return ScmBlockLocationProtocolProtos.Status.INTERNAL_ERROR;
    }

    public ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto allocateScmBlock(ScmBlockLocationProtocolProtos.AllocateScmBlockRequestProto request) throws IOException {
        List allocatedBlocks = this.impl.allocateBlock(request.getSize(), request.getNumBlocks(), request.getType(), request.getFactor(), request.getOwner(), ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)request.getExcludeList()));
        ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.Builder builder = ScmBlockLocationProtocolProtos.AllocateScmBlockResponseProto.newBuilder();
        if (allocatedBlocks.size() < request.getNumBlocks()) {
            throw new SCMException("Allocated " + allocatedBlocks.size() + " blocks. Requested " + request.getNumBlocks() + " blocks", SCMException.ResultCodes.FAILED_TO_ALLOCATE_ENOUGH_BLOCKS);
        }
        for (AllocatedBlock block : allocatedBlocks) {
            builder.addBlocks(ScmBlockLocationProtocolProtos.AllocateBlockResponse.newBuilder().setContainerBlockID(block.getBlockID().getProtobuf()).setPipeline(block.getPipeline().getProtobufMessage()));
        }
        return builder.build();
    }

    public ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto deleteScmKeyBlocks(ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksRequestProto req) throws IOException {
        ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.Builder resp = ScmBlockLocationProtocolProtos.DeleteScmKeyBlocksResponseProto.newBuilder();
        List infoList = req.getKeyBlocksList().stream().map(BlockGroup::getFromProto).collect(Collectors.toList());
        List results = this.impl.deleteKeyBlocks(infoList);
        for (DeleteBlockGroupResult result : results) {
            ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.Builder deleteResult = ScmBlockLocationProtocolProtos.DeleteKeyBlocksResultProto.newBuilder().setObjectKey(result.getObjectKey()).addAllBlockResults((Iterable)result.getBlockResultProtoList());
            resp.addResults(deleteResult.build());
        }
        return resp.build();
    }

    public HddsProtos.GetScmInfoResponseProto getScmInfo(HddsProtos.GetScmInfoRequestProto req) throws IOException {
        ScmInfo scmInfo = this.impl.getScmInfo();
        return HddsProtos.GetScmInfoResponseProto.newBuilder().setClusterId(scmInfo.getClusterId()).setScmId(scmInfo.getScmId()).build();
    }

    public ScmBlockLocationProtocolProtos.SortDatanodesResponseProto sortDatanodes(ScmBlockLocationProtocolProtos.SortDatanodesRequestProto request) throws ServiceException {
        ScmBlockLocationProtocolProtos.SortDatanodesResponseProto.Builder resp = ScmBlockLocationProtocolProtos.SortDatanodesResponseProto.newBuilder();
        try {
            List nodeList = request.getNodeNetworkNameList();
            List results = this.impl.sortDatanodes(nodeList, request.getClient());
            if (results != null && results.size() > 0) {
                results.stream().forEach(dn -> resp.addNode(dn.getProtoBufMessage()));
            }
            return resp.build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }
}

