/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyPipelineSafeModeRule
extends SafeModeExitRule<Pipeline> {
    public static final Logger LOG = LoggerFactory.getLogger(HealthyPipelineSafeModeRule.class);
    private int healthyPipelineThresholdCount;
    private int currentHealthyPipelineCount = 0;
    private final double healthyPipelinesPercent;
    private final Set<PipelineID> processedPipelineIDs = new HashSet<PipelineID>();

    HealthyPipelineSafeModeRule(String ruleName, EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager manager, Configuration configuration) {
        super(manager, ruleName, eventQueue);
        this.healthyPipelinesPercent = configuration.getDouble("hdds.scm.safemode.healthy.pipeline.pct", 0.1);
        int minDatanodes = configuration.getInt("hdds.scm.safemode.min.datanode", 1);
        int minHealthyPipelines = minDatanodes / 3;
        Preconditions.checkArgument((this.healthyPipelinesPercent >= 0.0 && this.healthyPipelinesPercent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.healthy.pipeline.pct value should be >= 0.0 and <= 1.0");
        int pipelineCount = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.ALLOCATED).size();
        this.healthyPipelineThresholdCount = Math.max(minHealthyPipelines, (int)Math.ceil(this.healthyPipelinesPercent * (double)pipelineCount));
        LOG.info("Total pipeline count is {}, healthy pipeline threshold count is {}", (Object)pipelineCount, (Object)this.healthyPipelineThresholdCount);
        this.getSafeModeMetrics().setNumHealthyPipelinesThreshold(this.healthyPipelineThresholdCount);
    }

    @VisibleForTesting
    public void setHealthyPipelineThresholdCount(int actualPipelineCount) {
        this.healthyPipelineThresholdCount = (int)Math.ceil(this.healthyPipelinesPercent * (double)actualPipelineCount);
    }

    @Override
    protected TypedEvent<Pipeline> getEventType() {
        return SCMEvents.OPEN_PIPELINE;
    }

    @Override
    protected boolean validate() {
        return this.currentHealthyPipelineCount >= this.healthyPipelineThresholdCount;
    }

    @Override
    protected void process(Pipeline pipeline) {
        Preconditions.checkNotNull((Object)pipeline);
        if (pipeline.getType() == HddsProtos.ReplicationType.RATIS && pipeline.getFactor() == HddsProtos.ReplicationFactor.THREE && pipeline.isHealthy() && !this.processedPipelineIDs.contains(pipeline.getId())) {
            this.getSafeModeMetrics().incCurrentHealthyPipelinesCount();
            ++this.currentHealthyPipelineCount;
            this.processedPipelineIDs.add(pipeline.getId());
        }
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. Healthy pipelines reported count is {}, required healthy pipeline reported count is {}", (Object)this.currentHealthyPipelineCount, (Object)this.healthyPipelineThresholdCount);
        }
    }

    @Override
    protected void cleanup() {
        this.processedPipelineIDs.clear();
    }

    @VisibleForTesting
    public int getCurrentHealthyPipelineCount() {
        return this.currentHealthyPipelineCount;
    }

    @VisibleForTesting
    public int getHealthyPipelineThresholdCount() {
        return this.healthyPipelineThresholdCount;
    }
}

