/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeMetrics;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;

public abstract class SafeModeExitRule<T>
implements EventHandler<T> {
    private final SCMSafeModeManager safeModeManager;
    private final String ruleName;

    public SafeModeExitRule(SCMSafeModeManager safeModeManager, String ruleName, EventQueue eventQueue) {
        this.safeModeManager = safeModeManager;
        this.ruleName = ruleName;
        eventQueue.addHandler(this.getEventType(), (EventHandler)this);
    }

    public String getRuleName() {
        return this.ruleName;
    }

    protected abstract TypedEvent<T> getEventType();

    protected abstract boolean validate();

    protected abstract void process(T var1);

    protected abstract void cleanup();

    public final void onMessage(T report, EventPublisher publisher) {
        if (this.scmInSafeMode()) {
            if (this.validate()) {
                this.safeModeManager.validateSafeModeExitRules(this.ruleName, publisher);
                this.cleanup();
                return;
            }
            this.process(report);
            if (this.validate()) {
                this.safeModeManager.validateSafeModeExitRules(this.ruleName, publisher);
                this.cleanup();
            }
        }
    }

    protected boolean scmInSafeMode() {
        return this.safeModeManager.getInSafeMode();
    }

    protected SafeModeMetrics getSafeModeMetrics() {
        return this.safeModeManager.getSafeModeMetrics();
    }
}

