/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.DeleteBlockResult;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.common.DeleteBlockGroupResult;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockProtocolServer
implements ScmBlockLocationProtocol,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMBlockProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final StorageContainerManager scm;
    private final OzoneConfiguration conf;
    private final RPC.Server blockRpcServer;
    private final InetSocketAddress blockRpcAddress;
    private final ProtocolMessageMetrics protocolMessageMetrics;

    public SCMBlockProtocolServer(OzoneConfiguration conf, StorageContainerManager scm) throws IOException {
        this.scm = scm;
        this.conf = conf;
        int handlerCount = conf.getInt("ozone.scm.handler.count.key", 10);
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.protocolMessageMetrics = ProtocolMessageMetrics.create((String)"ScmBlockLocationProtocol", (String)"SCM Block location protocol counters", (ProtocolMessageEnum[])ScmBlockLocationProtocolProtos.Type.values());
        BlockingService blockProtoPbService = ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.newReflectiveBlockingService((ScmBlockLocationProtocolProtos.ScmBlockLocationProtocolService.BlockingInterface)new ScmBlockLocationProtocolServerSideTranslatorPB(this, this.protocolMessageMetrics));
        InetSocketAddress scmBlockAddress = HddsServerUtil.getScmBlockClientBindAddress((Configuration)conf);
        this.blockRpcServer = StorageContainerManager.startRpcServer(conf, scmBlockAddress, ScmBlockLocationProtocolPB.class, blockProtoPbService, handlerCount);
        this.blockRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)"ozone.scm.block.client.address", (InetSocketAddress)scmBlockAddress, (RPC.Server)this.blockRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.blockRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
    }

    public RPC.Server getBlockRpcServer() {
        return this.blockRpcServer;
    }

    public InetSocketAddress getBlockRpcAddress() {
        return this.blockRpcAddress;
    }

    public void start() {
        this.protocolMessageMetrics.register();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Block Protocol", this.getBlockRpcAddress()));
        this.getBlockRpcServer().start();
    }

    public void stop() {
        try {
            this.protocolMessageMetrics.unregister();
            LOG.info("Stopping the RPC server for Block Protocol");
            this.getBlockRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Block Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Block Protocol");
        this.getBlockRpcServer().join();
    }

    public List<AllocatedBlock> allocateBlock(long size, int num, HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner, ExcludeList excludeList) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("size", String.valueOf(size));
        auditMap.put("type", type.name());
        auditMap.put("factor", factor.name());
        auditMap.put("owner", owner);
        ArrayList<AllocatedBlock> blocks = new ArrayList<AllocatedBlock>(num);
        boolean auditSuccess = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Allocating {} blocks of size {}, with {}", new Object[]{num, size, excludeList});
        }
        try {
            for (int i = 0; i < num; ++i) {
                AllocatedBlock block = this.scm.getScmBlockManager().allocateBlock(size, type, factor, owner, excludeList);
                if (block == null) continue;
                blocks.add(block);
            }
            ArrayList<AllocatedBlock> i = blocks;
            return i;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.ALLOCATE_BLOCK, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public List<DeleteBlockGroupResult> deleteKeyBlocks(List<BlockGroup> keyBlocksInfoList) throws IOException {
        LOG.info("SCM is informed by OM to delete {} blocks", (Object)keyBlocksInfoList.size());
        ArrayList<DeleteBlockGroupResult> results = new ArrayList<DeleteBlockGroupResult>();
        HashMap auditMap = Maps.newHashMap();
        for (BlockGroup keyBlocks : keyBlocksInfoList) {
            ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result resultCode;
            try {
                auditMap.put("keyBlockToDelete", keyBlocks.toString());
                this.scm.getScmBlockManager().deleteBlocks(keyBlocks.getBlockIDList());
                resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.success;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.DELETE_KEY_BLOCK, auditMap));
            }
            catch (SCMException scmEx) {
                LOG.warn("Fail to delete block: {}", (Object)keyBlocks.getGroupID(), (Object)scmEx);
                AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.DELETE_KEY_BLOCK, auditMap, scmEx));
                switch (scmEx.getResult()) {
                    case SAFE_MODE_EXCEPTION: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.safeMode;
                        break;
                    }
                    case FAILED_TO_FIND_BLOCK: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.errorNotFound;
                        break;
                    }
                    default: {
                        resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.unknownFailure;
                        break;
                    }
                }
            }
            catch (IOException ex) {
                LOG.warn("Fail to delete blocks for object key: {}", (Object)keyBlocks.getGroupID(), (Object)ex);
                AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.DELETE_KEY_BLOCK, auditMap, ex));
                resultCode = ScmBlockLocationProtocolProtos.DeleteScmBlockResult.Result.unknownFailure;
            }
            ArrayList<DeleteBlockResult> blockResultList = new ArrayList<DeleteBlockResult>();
            for (BlockID blockKey : keyBlocks.getBlockIDList()) {
                blockResultList.add(new DeleteBlockResult(blockKey, resultCode));
            }
            results.add(new DeleteBlockGroupResult(keyBlocks.getGroupID(), blockResultList));
        }
        return results;
    }

    public ScmInfo getScmInfo() throws IOException {
        boolean auditSuccess = true;
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId());
            ScmInfo scmInfo = builder.build();
            return scmInfo;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.GET_SCM_INFO, null));
            }
        }
    }

    public List<DatanodeDetails> sortDatanodes(List<String> nodes, String clientMachine) throws IOException {
        boolean auditSuccess = true;
        try {
            NodeManager nodeManager = this.scm.getScmNodeManager();
            Node client = null;
            List<DatanodeDetails> possibleClients = nodeManager.getNodesByAddress(clientMachine);
            if (possibleClients.size() > 0) {
                client = (Node)possibleClients.get(0);
            }
            ArrayList nodeList = new ArrayList();
            nodes.stream().forEach(uuid -> {
                DatanodeDetails node = nodeManager.getNodeByUuid((String)uuid);
                if (node != null) {
                    nodeList.add(node);
                }
            });
            List sortedNodeList = this.scm.getClusterMap().sortByDistanceCost(client, nodeList, nodes.size());
            ArrayList<DatanodeDetails> ret = new ArrayList<DatanodeDetails>();
            sortedNodeList.stream().forEach(node -> ret.add((DatanodeDetails)node));
            ArrayList<DatanodeDetails> arrayList = ret;
            return arrayList;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)SCMAction.SORT_DATANODE, null, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)SCMAction.SORT_DATANODE, null));
            }
        }
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }
}

