/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="hdds.scm.http")
public class SCMHTTPServerConfig {
    @Config(key="kerberos.principal", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.SECURITY}, description="This Kerberos principal is used when communicating to the HTTP server of SCM.The protocol used is SPNEGO.")
    private String principal = "";
    @Config(key="kerberos.keytab", type=ConfigType.STRING, defaultValue="", tags={ConfigTag.SECURITY}, description="The keytab file used by SCM http server to login as its service principal.")
    private String keytab = "";

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.principal = kerberosPrincipal;
    }

    public void setKerberosKeytab(String kerberosKeytab) {
        this.keytab = kerberosKeytab;
    }

    public String getKerberosPrincipal() {
        return this.principal;
    }

    public String getKerberosKeytab() {
        return this.keytab;
    }

    public static class ConfigStrings {
        public static final String HDDS_SCM_HTTP_KERBEROS_PRINCIPAL_KEY = "hdds.scm.http.kerberos.principal";
        public static final String HDDS_SCM_HTTP_KERBEROS_KEYTAB_FILE_KEY = "hdds.scm.http.kerberos.keytab";
    }
}

